/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.util.Collection;
import java.util.HashMap;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.Indexer;

public class IndexerService {
    protected static final IndexerService INDEXER_SERVICE = new IndexerService();
    protected HashMap<String, Indexers> mapProviders = new HashMap();

    public static IndexerService getInstance() {
        return INDEXER_SERVICE;
    }

    protected IndexerService() {
        Collection<Indexer> providers = ExtensionService.getInstance().load(Indexer.class);
        for (Indexer provider : providers) {
            for (String selector : provider.getSelectors()) {
                Indexers indexers = this.mapProviders.get(selector);
                if (indexers == null) {
                    indexers = new Indexers();
                    this.mapProviders.put(selector, indexers);
                }
                indexers.add(provider);
            }
        }
    }

    public Indexer get(Container.Entry entry) {
        Indexer indexer = this.get(entry.getContainer().getType(), entry);
        return indexer != null ? indexer : this.get("*", entry);
    }

    protected Indexer get(String containerType, Container.Entry entry) {
        String path = entry.getPath();
        String type = entry.isDirectory() ? "dir" : "file";
        String prefix = containerType + ':' + type;
        Indexer indexer = null;
        Indexers indexers = this.mapProviders.get(prefix + ':' + path);
        if (indexers != null) {
            indexer = indexers.match(path);
        }
        if (indexer == null) {
            int lastSlashIndex = path.lastIndexOf(47);
            String name = path.substring(lastSlashIndex + 1);
            indexers = this.mapProviders.get(prefix + ":*/" + name);
            if (indexers != null) {
                indexer = indexers.match(path);
            }
            if (indexer == null) {
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    String extension = name.substring(index + 1);
                    indexers = this.mapProviders.get(prefix + ":*." + extension);
                    if (indexers != null) {
                        indexer = indexers.match(path);
                    }
                }
                if (indexer == null && (indexers = this.mapProviders.get(prefix + ":*")) != null) {
                    indexer = indexers.match(path);
                }
            }
        }
        return indexer;
    }

    protected static class Indexers {
        protected HashMap<String, Indexer> indexers = new HashMap();
        protected Indexer defaultIndexer;

        protected Indexers() {
        }

        public void add(Indexer indexer) {
            if (indexer.getPathPattern() != null) {
                this.indexers.put(indexer.getPathPattern().pattern(), indexer);
            } else {
                this.defaultIndexer = indexer;
            }
        }

        public Indexer match(String path) {
            for (Indexer indexer : this.indexers.values()) {
                if (!indexer.getPathPattern().matcher(path).matches()) continue;
                return indexer;
            }
            return this.defaultIndexer;
        }
    }
}

