/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.util.DefaultList;

public class StringConcatenationUtil {
    public static Expression create(Expression expression, int lineNumber, String typeName) {
        MethodInvocationExpression mie;
        if (expression.getClass() == ClassFileMethodInvocationExpression.class && (mie = (MethodInvocationExpression)expression).getParameters() != null && !mie.getParameters().isList() && "append".equals(mie.getName())) {
            String internalTypeName;
            Expression concatenatedStringExpression = (Expression)mie.getParameters().getFirst();
            Expression expr = mie.getExpression();
            boolean firstParameterHaveGenericType = false;
            while (expr.getClass() == ClassFileMethodInvocationExpression.class && (mie = (MethodInvocationExpression)expr).getParameters() != null && !mie.getParameters().isList() && "append".equals(mie.getName())) {
                firstParameterHaveGenericType = ((Expression)mie.getParameters().getFirst()).getType().isGeneric();
                concatenatedStringExpression = new BinaryOperatorExpression(mie.getLineNumber(), ObjectType.TYPE_STRING, (Expression)mie.getParameters(), "+", concatenatedStringExpression, 4);
                expr = mie.getExpression();
            }
            if (expr.getClass() == ClassFileNewExpression.class && ("Ljava/lang/StringBuilder;".equals(internalTypeName = expr.getType().getDescriptor()) || "Ljava/lang/StringBuffer;".equals(internalTypeName))) {
                ClassFileNewExpression ne = (ClassFileNewExpression)expr;
                if (ne.getParameters() == null) {
                    if (!firstParameterHaveGenericType) {
                        return concatenatedStringExpression;
                    }
                } else if (!ne.getParameters().isList() && ObjectType.TYPE_STRING.equals((expr = (Expression)ne.getParameters().getFirst()).getType())) {
                    return new BinaryOperatorExpression(ne.getLineNumber(), ObjectType.TYPE_STRING, expr, "+", concatenatedStringExpression, 4);
                }
            }
        }
        return new ClassFileMethodInvocationExpression(null, lineNumber, null, ObjectType.TYPE_STRING, expression, typeName, "toString", "()Ljava/lang/String;", null, null);
    }

    public static Expression create(String recipe, BaseExpression parameters) {
        StringTokenizer st = new StringTokenizer(recipe, "\u0001", true);
        if (st.hasMoreTokens()) {
            Expression expression;
            String token = st.nextToken();
            Expression expression2 = expression = token.equals("\u0001") ? StringConcatenationUtil.createFirstStringConcatenationItem((Expression)parameters.getFirst()) : new StringConstantExpression(token);
            if (parameters.isList()) {
                DefaultList list = parameters.getList();
                int index = 0;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    Expression e = token.equals("\u0001") ? (Expression)list.get(index++) : new StringConstantExpression(token);
                    expression = new BinaryOperatorExpression(expression.getLineNumber(), ObjectType.TYPE_STRING, expression, "+", e, 6);
                }
            } else {
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    Expression e = token.equals("\u0001") ? (Expression)parameters.getFirst() : new StringConstantExpression(token);
                    expression = new BinaryOperatorExpression(expression.getLineNumber(), ObjectType.TYPE_STRING, expression, "+", e, 6);
                }
            }
            return expression;
        }
        return StringConstantExpression.EMPTY_STRING;
    }

    public static Expression create(BaseExpression parameters) {
        switch (parameters.size()) {
            case 0: {
                return StringConstantExpression.EMPTY_STRING;
            }
            case 1: {
                return StringConcatenationUtil.createFirstStringConcatenationItem((Expression)parameters.getFirst());
            }
        }
        Iterator iterator = parameters.iterator();
        Expression expression = StringConcatenationUtil.createFirstStringConcatenationItem((Expression)iterator.next());
        while (iterator.hasNext()) {
            expression = new BinaryOperatorExpression(expression.getLineNumber(), ObjectType.TYPE_STRING, expression, "+", (Expression)iterator.next(), 6);
        }
        return expression;
    }

    private static Expression createFirstStringConcatenationItem(Expression expression) {
        if (!expression.getType().equals(ObjectType.TYPE_STRING)) {
            expression = new BinaryOperatorExpression(expression.getLineNumber(), ObjectType.TYPE_STRING, StringConstantExpression.EMPTY_STRING, "+", expression, 6);
        }
        return expression;
    }
}

