/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.fragment;

import org.jd.core.v1.model.fragment.Fragment;
import org.jd.core.v1.model.fragment.FragmentVisitor;

public abstract class FlexibleFragment
implements Fragment {
    protected final int minimalLineCount;
    protected int maximalLineCount;
    protected int initialLineCount;
    protected int lineCount;
    protected final int weight;
    protected final String label;

    public FlexibleFragment(int minimalLineCount, int lineCount, int maximalLineCount, int weight, String label) {
        this.minimalLineCount = minimalLineCount;
        this.maximalLineCount = maximalLineCount;
        this.initialLineCount = this.lineCount = lineCount;
        this.weight = weight;
        this.label = label;
    }

    public void resetLineCount() {
        this.lineCount = this.initialLineCount;
    }

    public int getMinimalLineCount() {
        return this.minimalLineCount;
    }

    public int getMaximalLineCount() {
        return this.maximalLineCount;
    }

    public int getInitialLineCount() {
        return this.initialLineCount;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean incLineCount(boolean force) {
        if (this.lineCount < this.maximalLineCount) {
            ++this.lineCount;
            return true;
        }
        return false;
    }

    public boolean decLineCount(boolean force) {
        if (this.lineCount > this.minimalLineCount) {
            --this.lineCount;
            return true;
        }
        return false;
    }

    public String toString() {
        return "{minimal-line-count=" + this.getMinimalLineCount() + ", maximal-line-count=" + this.getMaximalLineCount() + ", initial-line-count=" + this.getInitialLineCount() + ", line-count=" + this.getLineCount() + ", weight=" + this.getWeight() + (this.getLabel() != null ? ", label='" + this.label + "'}" : "}");
    }

    @Override
    public void accept(FragmentVisitor visitor) {
        visitor.visit(this);
    }
}

