/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeObjCRefinementAnnotationCheckerKt;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ObjCExportMetaAnnotations;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeObjCRefinementAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "hidesFromObjCSupportedTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "[Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "refinesInSwiftSupportedTargets", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.native"})
public final class NativeObjCRefinementAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeObjCRefinementAnnotationChecker INSTANCE = new NativeObjCRefinementAnnotationChecker();
    @NotNull
    private static final KotlinTarget[] hidesFromObjCSupportedTargets;
    @NotNull
    private static final KotlinTarget[] refinesInSwiftSupportedTargets;

    private NativeObjCRefinementAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        block7: {
            KtElement reportLocation;
            AnnotationDescriptor it;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(descriptor instanceof ClassDescriptor) || ((ClassDescriptor)descriptor).getKind() != ClassKind.ANNOTATION_CLASS) {
                return;
            }
            ObjCExportMetaAnnotations objCExportMetaAnnotations = NativeObjCRefinementAnnotationCheckerKt.findObjCExportMetaAnnotations(descriptor);
            if (objCExportMetaAnnotations == null) {
                return;
            }
            ObjCExportMetaAnnotations objCExportMetaAnnotations2 = objCExportMetaAnnotations;
            AnnotationDescriptor objCAnnotation = objCExportMetaAnnotations2.component1();
            AnnotationDescriptor swiftAnnotation = objCExportMetaAnnotations2.component2();
            if (objCAnnotation == null && swiftAnnotation == null) {
                return;
            }
            if (objCAnnotation != null && swiftAnnotation != null) {
                KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(swiftAnnotation);
                KtElement reportLocation2 = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
                context.getTrace().report(ErrorsNative.REDUNDANT_SWIFT_REFINEMENT.on((KtElement)((PsiElement)reportLocation2)));
            }
            Set<KotlinTarget> targets = AnnotationChecker.Companion.applicableTargetSet((ClassDescriptor)descriptor);
            AnnotationDescriptor annotationDescriptor = objCAnnotation;
            if (annotationDescriptor != null) {
                it = annotationDescriptor;
                boolean bl = false;
                if (!((Collection)SetsKt.minus(targets, (Object[])hidesFromObjCSupportedTargets)).isEmpty()) {
                    KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(it);
                    reportLocation = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
                    context.getTrace().report(ErrorsNative.INVALID_OBJC_HIDES_TARGETS.on((KtElement)((PsiElement)reportLocation)));
                }
            }
            AnnotationDescriptor annotationDescriptor2 = swiftAnnotation;
            if (annotationDescriptor2 == null) break block7;
            it = annotationDescriptor2;
            boolean bl = false;
            if (!((Collection)SetsKt.minus(targets, (Object[])refinesInSwiftSupportedTargets)).isEmpty()) {
                KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(it);
                reportLocation = ktAnnotationEntry != null ? (KtElement)ktAnnotationEntry : (KtElement)declaration;
                context.getTrace().report(ErrorsNative.INVALID_REFINES_IN_SWIFT_TARGETS.on((KtElement)((PsiElement)reportLocation)));
            }
        }
    }

    static {
        KotlinTarget[] kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.PROPERTY, KotlinTarget.CLASS};
        hidesFromObjCSupportedTargets = kotlinTargetArray;
        kotlinTargetArray = new KotlinTarget[]{KotlinTarget.FUNCTION, KotlinTarget.PROPERTY};
        refinesInSwiftSupportedTargets = kotlinTargetArray;
    }
}

