/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.core.AuthTokenProvider;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventTarget;
import com.google.firebase.database.core.RunLoop;

public class DatabaseConfig
extends Context {
    public synchronized void setEventTarget(EventTarget eventTarget) {
        this.assertUnfrozen();
        this.eventTarget = eventTarget;
    }

    public void setRunLoop(RunLoop runLoop) {
        this.runLoop = runLoop;
    }

    public void setAuthTokenProvider(AuthTokenProvider provider) {
        this.authTokenProvider = provider;
    }

    public synchronized void setSessionPersistenceKey(String sessionKey) {
        this.assertUnfrozen();
        if (sessionKey == null || sessionKey.isEmpty()) {
            throw new IllegalArgumentException("Session identifier is not allowed to be empty or null!");
        }
        this.persistenceKey = sessionKey;
    }

    public synchronized void setPersistenceEnabled(boolean isEnabled) {
        this.assertUnfrozen();
        this.persistenceEnabled = isEnabled;
    }

    public synchronized void setPersistenceCacheSizeBytes(long cacheSizeInBytes) {
        this.assertUnfrozen();
        if (cacheSizeInBytes < 0x100000L) {
            throw new DatabaseException("The minimum cache size must be at least 1MB");
        }
        if (cacheSizeInBytes > 0x6400000L) {
            throw new DatabaseException("Firebase Database currently doesn't support a cache size larger than 100MB");
        }
        this.cacheSize = cacheSizeInBytes;
    }

    public synchronized void setFirebaseApp(FirebaseApp app) {
        this.firebaseApp = app;
    }
}

