/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.params.IParams;

@Experimental
public class VAddParams
implements IParams {
    private boolean cas;
    private QuantizationType quantization;
    private Integer ef;
    private String attributes;
    private Integer m;

    public VAddParams cas() {
        this.cas = true;
        return this;
    }

    public VAddParams noQuant() {
        this.quantization = QuantizationType.NOQUANT;
        return this;
    }

    public VAddParams q8() {
        this.quantization = QuantizationType.Q8;
        return this;
    }

    public VAddParams bin() {
        this.quantization = QuantizationType.BIN;
        return this;
    }

    public VAddParams ef(int buildExplorationFactor) {
        this.ef = buildExplorationFactor;
        return this;
    }

    public VAddParams setAttr(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public VAddParams m(int numLinks) {
        this.m = numLinks;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.cas) {
            args.add(Protocol.Keyword.CAS);
        }
        if (this.quantization != null) {
            switch (this.quantization) {
                case NOQUANT: {
                    args.add(Protocol.Keyword.NOQUANT);
                    break;
                }
                case Q8: {
                    args.add(Protocol.Keyword.Q8);
                    break;
                }
                case BIN: {
                    args.add(Protocol.Keyword.BIN);
                }
            }
        }
        if (this.ef != null) {
            args.add(Protocol.Keyword.EF).add(this.ef);
        }
        if (this.attributes != null) {
            args.add(Protocol.Keyword.SETATTR).add(this.attributes);
        }
        if (this.m != null) {
            args.add(Protocol.Keyword.M).add(this.m);
        }
    }

    public static enum QuantizationType {
        NOQUANT,
        Q8,
        BIN;

    }
}

