/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.model.AnomalyDetectorExecutionInput;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.AnomalyResultAction;
import org.opensearch.ad.transport.AnomalyResultRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestExecuteAnomalyDetectorAction
extends BaseRestHandler {
    public static final String DETECT_DATA_ACTION = "execute_anomaly_detector";
    private volatile TimeValue requestTimeout;
    private final Logger logger = LogManager.getLogger(RestExecuteAnomalyDetectorAction.class);

    public RestExecuteAnomalyDetectorAction(Settings settings, ClusterService clusterService) {
        this.requestTimeout = (TimeValue)AnomalyDetectorSettings.AD_REQUEST_TIMEOUT.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_REQUEST_TIMEOUT, it -> {
            this.requestTimeout = it;
        });
    }

    public String getName() {
        return DETECT_DATA_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        AnomalyDetectorExecutionInput input = this.getConfigExecutionInput(request);
        return channel -> {
            String error = this.validateAdExecutionInput(input);
            if (StringUtils.isNotBlank((CharSequence)error)) {
                channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, error));
                return;
            }
            AnomalyResultRequest getRequest = new AnomalyResultRequest(input.getDetectorId(), input.getPeriodStart().toEpochMilli(), input.getPeriodEnd().toEpochMilli());
            client.execute((ActionType)AnomalyResultAction.INSTANCE, (ActionRequest)getRequest, (ActionListener)new RestToXContentListener(channel));
        };
    }

    private AnomalyDetectorExecutionInput getConfigExecutionInput(RestRequest request) throws IOException {
        String detectorId = null;
        if (request.hasParam("detectorID")) {
            detectorId = request.param("detectorID");
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        AnomalyDetectorExecutionInput input = AnomalyDetectorExecutionInput.parse(parser, detectorId);
        if (detectorId != null) {
            input.setDetectorId(detectorId);
        }
        return input;
    }

    private String validateAdExecutionInput(AnomalyDetectorExecutionInput input) {
        if (StringUtils.isBlank((CharSequence)input.getDetectorId()) && input.getDetector() == null) {
            return "Must set anomaly detector id or detector";
        }
        if (input.getPeriodStart() == null || input.getPeriodEnd() == null) {
            return "Must set both period start and end date with epoch of milliseconds";
        }
        if (!input.getPeriodStart().isBefore(input.getPeriodEnd())) {
            return "Period start date should be before end date";
        }
        return null;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_run"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_run")));
    }
}

