/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rest.RestRequest;

public class GetConversationsRequest
extends ActionRequest {
    private int maxResults = 10;
    private int from = 0;

    public GetConversationsRequest(int maxResults) {
        this.maxResults = maxResults;
    }

    public GetConversationsRequest(int maxResults, int from) {
        this.maxResults = maxResults;
        this.from = from;
    }

    public GetConversationsRequest() {
    }

    public GetConversationsRequest(StreamInput in) throws IOException {
        super(in);
        this.maxResults = in.readInt();
        this.from = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.maxResults);
        out.writeInt(this.from);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.maxResults <= 0) {
            exception = ValidateActions.addValidationError((String)"Can't list 0 or negative conversations", exception);
        }
        return exception;
    }

    public static GetConversationsRequest fromRestRequest(RestRequest request) throws IOException {
        if (request.hasParam("next_token")) {
            int maxResults = request.hasParam("max_results") ? Integer.parseInt(request.param("max_results")) : 10;
            int nextToken = Integer.parseInt(request.param("next_token"));
            return new GetConversationsRequest(maxResults, nextToken);
        }
        int maxResults = request.hasParam("max_results") ? Integer.parseInt(request.param("max_results")) : 10;
        return new GetConversationsRequest(maxResults);
    }

    @Generated
    public int getMaxResults() {
        return this.maxResults;
    }

    @Generated
    public int getFrom() {
        return this.from;
    }
}

