/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.explore;

import com.o19s.es.explore.ExplorerQuery;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.ltr.stats.LTRStats;
import org.opensearch.ltr.stats.StatName;

public class ExplorerQueryBuilder
extends AbstractQueryBuilder<ExplorerQueryBuilder>
implements NamedWriteable {
    public static final String NAME = "match_explorer";
    private static final ParseField QUERY_NAME = new ParseField("query", new String[0]);
    private static final ParseField TYPE_NAME = new ParseField("type", new String[0]);
    private static final ObjectParser<ExplorerQueryBuilder, Void> PARSER = new ObjectParser("match_explorer", ExplorerQueryBuilder::new);
    private QueryBuilder query;
    private String type;
    private LTRStats ltrStats;

    public ExplorerQueryBuilder() {
    }

    public ExplorerQueryBuilder(StreamInput in, LTRStats ltrStats) throws IOException {
        super(in);
        this.query = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.type = in.readString();
        this.ltrStats = ltrStats;
    }

    public static ExplorerQueryBuilder fromXContent(XContentParser parser, LTRStats ltrStats) throws IOException {
        ExplorerQueryBuilder builder;
        try {
            builder = (ExplorerQueryBuilder)((Object)PARSER.parse(parser, null));
        }
        catch (IllegalArgumentException iae) {
            throw new ParsingException(parser.getTokenLocation(), iae.getMessage(), (Throwable)iae, new Object[0]);
        }
        if (builder.query == null) {
            throw new ParsingException(parser.getTokenLocation(), "Field [" + String.valueOf(QUERY_NAME) + "] is mandatory.", new Object[0]);
        }
        if (builder.statsType() == null) {
            throw new ParsingException(parser.getTokenLocation(), "Field [" + String.valueOf(TYPE_NAME) + "] is mandatory.", new Object[0]);
        }
        builder.ltrStats(ltrStats);
        return builder;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.query);
        out.writeString(this.type);
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        this.printBoostAndQueryName(builder);
        builder.field(QUERY_NAME.getPreferredName(), (ToXContent)this.query);
        builder.field(TYPE_NAME.getPreferredName(), this.type);
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        this.ltrStats.getStat(StatName.LTR_REQUEST_TOTAL_COUNT.getName()).increment();
        return new ExplorerQuery(this.query.toQuery(context), this.type, this.ltrStats);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (queryRewriteContext != null) {
            ExplorerQueryBuilder rewritten = new ExplorerQueryBuilder();
            rewritten.type = this.type;
            rewritten.query = (QueryBuilder)Rewriteable.rewrite((Rewriteable)this.query, (QueryRewriteContext)queryRewriteContext);
            rewritten.ltrStats = this.ltrStats;
            rewritten.boost(this.boost());
            rewritten.queryName(this.queryName());
            if (!rewritten.equals((Object)this)) {
                return rewritten;
            }
        }
        return super.doRewrite(queryRewriteContext);
    }

    protected int doHashCode() {
        return Objects.hash(this.query, this.type);
    }

    protected boolean doEquals(ExplorerQueryBuilder other) {
        return Objects.equals(this.query, other.query) && Objects.equals(this.type, other.type);
    }

    public String getWriteableName() {
        return NAME;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public ExplorerQueryBuilder query(QueryBuilder query) {
        this.query = query;
        return this;
    }

    public ExplorerQueryBuilder ltrStats(LTRStats ltrStats) {
        this.ltrStats = ltrStats;
        return this;
    }

    public String statsType() {
        return this.type;
    }

    public ExplorerQueryBuilder statsType(String type) {
        this.type = type;
        return this;
    }

    static {
        PARSER.declareObject(ExplorerQueryBuilder::query, (parser, context) -> ExplorerQueryBuilder.parseInnerQueryBuilder((XContentParser)parser), QUERY_NAME);
        PARSER.declareString(ExplorerQueryBuilder::statsType, TYPE_NAME);
        ExplorerQueryBuilder.declareStandardFields(PARSER);
    }
}

