/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.passay.CharacterCharacteristicsRule;
import org.passay.CharacterRule;
import org.passay.DictionarySubstringRule;
import org.passay.EnglishCharacterData;
import org.passay.EnglishSequenceData;
import org.passay.IllegalSequenceRule;
import org.passay.LengthRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.RepeatCharacterRegexRule;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.UsernameRule;
import org.passay.dictionary.FileWordList;
import org.passay.dictionary.TernaryTreeDictionary;

public final class PasswordCli {
    private PasswordCli() {
    }

    public static void main(String[] args) throws Exception {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        String username = null;
        String password = null;
        try {
            RuleResult result;
            if (args.length < 2) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < args.length; ++i) {
                if ("-l".equals(args[i])) {
                    int min = Integer.parseInt(args[++i]);
                    int max = Integer.parseInt(args[++i]);
                    LengthRule rule = new LengthRule(min, max);
                    rules.add(rule);
                    continue;
                }
                if ("-c".equals(args[i])) {
                    CharacterCharacteristicsRule rule = new CharacterCharacteristicsRule();
                    rule.getRules().add(new CharacterRule(EnglishCharacterData.Digit, Integer.parseInt(args[++i])));
                    rule.getRules().add(new CharacterRule(EnglishCharacterData.Alphabetical, Integer.parseInt(args[++i])));
                    rule.getRules().add(new CharacterRule(EnglishCharacterData.Special, Integer.parseInt(args[++i])));
                    rule.getRules().add(new CharacterRule(EnglishCharacterData.UpperCase, Integer.parseInt(args[++i])));
                    rule.getRules().add(new CharacterRule(EnglishCharacterData.LowerCase, Integer.parseInt(args[++i])));
                    rule.setNumberOfCharacteristics(Integer.parseInt(args[++i]));
                    rules.add(rule);
                    continue;
                }
                if ("-d".equals(args[i])) {
                    TernaryTreeDictionary dict = new TernaryTreeDictionary(new FileWordList(new RandomAccessFile(args[++i], "r"), false));
                    DictionarySubstringRule rule = new DictionarySubstringRule(dict);
                    rule.setMatchBackwards(true);
                    rules.add(rule);
                    continue;
                }
                if ("-u".equals(args[i])) {
                    rules.add(new UsernameRule(true, true));
                    username = args[++i];
                    continue;
                }
                if ("-s".equals(args[i])) {
                    rules.add(new IllegalSequenceRule(EnglishSequenceData.USQwerty));
                    rules.add(new IllegalSequenceRule(EnglishSequenceData.Alphabetical));
                    rules.add(new IllegalSequenceRule(EnglishSequenceData.Numerical));
                    rules.add(new RepeatCharacterRegexRule());
                    continue;
                }
                if ("-h".equals(args[i])) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                password = args[i];
            }
            if (password == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            PasswordData pd = new PasswordData(password);
            PasswordValidator validator = new PasswordValidator(rules);
            if (username != null) {
                pd.setUsername(username);
            }
            if ((result = validator.validate(pd)).isValid()) {
                System.out.println("Valid password");
            } else {
                validator.getMessages(result).forEach(System.out::println);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: java " + PasswordCli.class.getName() + " <options> <password>");
            System.out.println();
            System.out.println("Options:");
            System.out.println("    -l <min> <max>");
            System.out.println("       set the min/max password length");
            System.out.println("    -c <digits> <alphabetical> <non-alphanumeric> <uppercase> <lowercase> <num>");
            System.out.println("       set the characters which must be present in the password");
            System.out.println("       the value for each category must be >= 0");
            System.out.println("       <num> is the number of these rules to enforce");
            System.out.println("    -d <file> <num>");
            System.out.println("       test password against a dictionary file");
            System.out.println("       <file> is a dictionary files");
            System.out.println("    -u <username>");
            System.out.println("       test for a given username");
            System.out.println("    -s test for sequences");
            System.out.println("    -h print this help message");
            System.exit(1);
        }
    }
}

