/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GenericItem;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.PointType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class LocationItem
extends GenericItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(PointType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(PointType.class, RefreshType.class);

    public LocationItem(String name) {
        super("Location", name);
    }

    public void send(PointType command) {
        this.internalSend(command);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    /*
     * WARNING - void declaration
     */
    public DecimalType distanceFrom(@Nullable LocationItem awayItem) {
        State state;
        if (awayItem != null && (state = awayItem.state) instanceof PointType) {
            PointType pointType = (PointType)state;
            PointType cfr_ignored_0 = (PointType)state;
            State state2 = this.state;
            if (state2 instanceof PointType) {
                void awayPoint;
                void thisPoint;
                PointType pointType2 = (PointType)state2;
                PointType cfr_ignored_1 = (PointType)state2;
                return thisPoint.distanceFrom((PointType)awayPoint);
            }
        }
        return new DecimalType(-1);
    }

    @Override
    public void setState(State state) {
        if (this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            this.applyState(state);
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> s.state() instanceof PointType)) {
            this.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

