/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.JButton;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.introduce.Bundle;
import org.netbeans.modules.java.hints.introduce.Flow;
import org.netbeans.modules.java.hints.introduce.InstanceRefFinder;
import org.netbeans.modules.java.hints.introduce.IntroduceExpressionBasedMethodFix;
import org.netbeans.modules.java.hints.introduce.IntroduceFixBase;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.introduce.IntroduceMethodPanel;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.MethodValidator;
import org.netbeans.modules.java.hints.introduce.ReferenceTransformer;
import org.netbeans.modules.java.hints.introduce.ScanStatement;
import org.netbeans.modules.java.hints.introduce.TargetDescription;
import org.netbeans.modules.java.hints.introduce.TreeUtils;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

public final class IntroduceMethodFix
extends IntroduceFixBase
implements Fix {
    private final List<TreePathHandle> parameters;
    private final List<TypeMirrorHandle> additionalLocalTypes;
    private final List<String> additionalLocalNames;
    private final TypeMirrorHandle returnType;
    private final TreePathHandle returnAssignTo;
    private final boolean declareVariableForReturnValue;
    private final Set<TypeMirrorHandle> thrownTypes;
    private final List<TreePathHandle> exits;
    private final boolean exitsFromAllBranches;
    private final int from;
    private final int to;
    private final List<TreePathHandle> typeVars;
    private final Collection<TargetDescription> targets;

    private static ScanStatement createAndRunScanner(CompilationInfo info, TreePath method, StatementTree from, StatementTree to, AtomicBoolean cancel) {
        HashMap<TypeMirror, TreePathHandle> typeVar2Def = new HashMap<TypeMirror, TreePathHandle>();
        LinkedList<TreePathHandle> typeVars = new LinkedList<TreePathHandle>();
        IntroduceHint.prepareTypeVars(method, info, typeVar2Def, typeVars);
        Flow.FlowResult flow = Flow.assignmentsForUse(info, method, cancel);
        if (flow == null || cancel.get()) {
            return null;
        }
        Map<Tree, Iterable<? extends TreePath>> assignmentsForUse = flow.getAssignmentsForUse();
        ScanStatement scanner = new ScanStatement(info, from, to, typeVar2Def, assignmentsForUse, cancel);
        Element methodEl = info.getTrees().getElement(method);
        if (methodEl != null && (methodEl.getKind() == ElementKind.METHOD || methodEl.getKind() == ElementKind.CONSTRUCTOR)) {
            ExecutableElement ee = (ExecutableElement)methodEl;
            scanner.localVariables.addAll(ee.getParameters());
        }
        scanner.scan(method, null);
        return scanner;
    }

    static Fix computeIntroduceMethod(CompilationInfo info, int start, int end, Map<IntroduceKind, String> errorMessage, AtomicBoolean cancel) {
        boolean declareVariableForReturnValue;
        TreePathHandle returnAssignTo;
        TypeMirror returnType;
        int[] statements = new int[2];
        TreePathHandle h = IntroduceMethodFix.validateSelectionForIntroduceMethod(info, start, end, statements);
        if (h == null) {
            errorMessage.put(IntroduceKind.CREATE_METHOD, "ERR_Invalid_Selection");
            return null;
        }
        TreePath block = h.resolve(info);
        TreePath method = TreeUtils.findMethod(block, true);
        if (method == null) {
            errorMessage.put(IntroduceKind.CREATE_METHOD, "ERR_Invalid_Selection");
            return null;
        }
        if (method.getLeaf().getKind() == Tree.Kind.METHOD && ((MethodTree)method.getLeaf()).getParameters().contains(block.getLeaf())) {
            errorMessage.put(IntroduceKind.CREATE_METHOD, "ERR_Invalid_Selection");
            return null;
        }
        Element methodEl = info.getTrees().getElement(method);
        List<? extends StatementTree> parentStatements = IntroduceHint.getStatements(block);
        List<? extends StatementTree> statementsToWrap = parentStatements.subList(statements[0], statements[1] + 1);
        ScanStatement scanner = IntroduceMethodFix.createAndRunScanner(info, method, statementsToWrap.get(0), statementsToWrap.get(statementsToWrap.size() - 1), cancel);
        if (scanner == null) {
            return null;
        }
        HashSet exceptions = new HashSet();
        int index = 0;
        TypeMirror methodReturnType = info.getTypes().getNoType(TypeKind.VOID);
        if (methodEl != null && (methodEl.getKind() == ElementKind.METHOD || methodEl.getKind() == ElementKind.CONSTRUCTOR)) {
            ExecutableElement ee = (ExecutableElement)methodEl;
            methodReturnType = ee.getReturnType();
        }
        LinkedList<TreePath> pathsOfStatementsToWrap = new LinkedList<TreePath>();
        for (StatementTree statementTree : parentStatements) {
            TreePath path = new TreePath(block, statementTree);
            if (index >= statements[0] && index <= statements[1]) {
                exceptions.addAll(info.getTreeUtilities().getUncaughtExceptions(path));
                pathsOfStatementsToWrap.add(path);
            }
            ++index;
        }
        boolean exitsFromAllBranches = Utilities.exitsFromAllBranchers(info, new TreePath(block, statementsToWrap.get(statementsToWrap.size() - 1)));
        String string = scanner.verifyExits(exitsFromAllBranches);
        if (string != null) {
            errorMessage.put(IntroduceKind.CREATE_METHOD, string);
            return null;
        }
        LinkedHashMap<VariableElement, Boolean> mergedVariableUse = new LinkedHashMap<VariableElement, Boolean>(scanner.usedLocalVariables);
        if (!scanner.usedAfterSelection.isEmpty()) {
            VariableElement variableElement = scanner.usedAfterSelection.entrySet().iterator().next().getKey();
        }
        for (Map.Entry entry : scanner.usedLocalVariables.entrySet()) {
            if (cancel.get()) {
                return null;
            }
            Boolean usedLocal = (Boolean)entry.getValue();
            if (usedLocal == null && Flow.definitellyAssigned(info, (VariableElement)entry.getKey(), pathsOfStatementsToWrap, cancel)) {
                mergedVariableUse.put((VariableElement)entry.getKey(), true);
                continue;
            }
            Boolean bl = scanner.usedAfterSelection.get(entry.getKey());
            mergedVariableUse.put((VariableElement)entry.getKey(), usedLocal != Boolean.FALSE && bl != Boolean.FALSE);
        }
        if (cancel.get()) {
            return null;
        }
        LinkedHashSet<VariableElement> additionalLocalVariables = new LinkedHashSet<VariableElement>();
        LinkedHashSet<VariableElement> linkedHashSet = new LinkedHashSet<VariableElement>();
        for (Map.Entry entry : mergedVariableUse.entrySet()) {
            if (entry.getValue() == null || ((Boolean)entry.getValue()).booleanValue()) {
                additionalLocalVariables.add((VariableElement)entry.getKey());
                continue;
            }
            linkedHashSet.add((VariableElement)entry.getKey());
            additionalLocalVariables.remove(entry.getKey());
        }
        LinkedList<TreePathHandle> params = new LinkedList<TreePathHandle>();
        for (VariableElement ve : linkedHashSet) {
            params.add(TreePathHandle.create((TreePath)info.getTrees().getPath(ve), (CompilationInfo)info));
        }
        additionalLocalVariables.removeAll(linkedHashSet);
        additionalLocalVariables.removeAll(scanner.selectionLocalVariables);
        LinkedList<TypeMirrorHandle> linkedList = new LinkedList<TypeMirrorHandle>();
        LinkedList<String> additionaLocalNames = new LinkedList<String>();
        for (VariableElement ve : additionalLocalVariables) {
            TypeMirror vt = Utilities.resolveTypeForDeclaration(info, ve.asType());
            linkedList.add(TypeMirrorHandle.create((TypeMirror)vt));
            additionaLocalNames.add(ve.getSimpleName().toString());
        }
        List<Object> exits = null;
        Tree lastStatement = statementsToWrap.get(statementsToWrap.size() - 1);
        if (parentStatements.get(parentStatements.size() - 1) == lastStatement) {
            Tree last = block.getLeaf();
            block10: for (Object search = block.getParentPath(); search != null; search = ((TreePath)search).getParentPath()) {
                switch (((TreePath)search).getLeaf().getKind()) {
                    case BLOCK: {
                        List<? extends StatementTree> thisBlockStatements = ((BlockTree)((TreePath)search).getLeaf()).getStatements();
                        if (thisBlockStatements.get(thisBlockStatements.size() - 1) != last) break block10;
                        break;
                    }
                    case IF: {
                        break;
                    }
                    case METHOD: {
                        Tree returnType2 = ((MethodTree)((TreePath)search).getLeaf()).getReturnType();
                        if (returnType2 != null && (returnType2.getKind() != Tree.Kind.PRIMITIVE_TYPE || ((PrimitiveTypeTree)returnType2).getPrimitiveTypeKind() != TypeKind.VOID)) break block10;
                        exits = Collections.emptyList();
                        break block10;
                    }
                    default: {
                        break block10;
                    }
                }
                last = ((TreePath)search).getLeaf();
            }
        }
        if (exits == null) {
            exits = new LinkedList<TreePathHandle>();
            for (TreePath tp : scanner.selectionExits) {
                if (!IntroduceMethodFix.isInsideSameClass(tp, method)) continue;
                exits.add(TreePathHandle.create((TreePath)tp, (CompilationInfo)info));
            }
        }
        Pattern p = Pattern.createPatternWithRemappableVariables(pathsOfStatementsToWrap, scanner.usedLocalVariables.keySet(), (boolean)true);
        Collection duplicates = Matcher.create((CompilationInfo)info).setCancel(cancel).match(p);
        int duplicatesCount = duplicates.size();
        if (!scanner.usedAfterSelection.isEmpty()) {
            VariableElement result = scanner.usedAfterSelection.keySet().iterator().next();
            returnType = Utilities.resolveTypeForDeclaration(info, result.asType());
            returnAssignTo = TreePathHandle.create((TreePath)info.getTrees().getPath(result), (CompilationInfo)info);
            declareVariableForReturnValue = scanner.selectionLocalVariables.contains(result);
        } else if (!exits.isEmpty() && !exitsFromAllBranches) {
            returnType = info.getTypes().getPrimitiveType(TypeKind.BOOLEAN);
            returnAssignTo = null;
            declareVariableForReturnValue = false;
        } else if (exitsFromAllBranches && scanner.hasReturns) {
            returnType = methodReturnType;
            returnAssignTo = null;
            declareVariableForReturnValue = false;
        } else {
            returnType = info.getTypes().getNoType(TypeKind.VOID);
            returnAssignTo = null;
            declareVariableForReturnValue = false;
        }
        HashSet<TypeMirrorHandle> exceptionHandles = new HashSet<TypeMirrorHandle>();
        for (TypeMirror tm : exceptions) {
            exceptionHandles.add(TypeMirrorHandle.create((TypeMirror)tm));
        }
        AtomicBoolean allIfaces = new AtomicBoolean();
        List<TargetDescription> viableTargets = IntroduceExpressionBasedMethodFix.computeViableTargets(info, block, statementsToWrap, duplicates, cancel, allIfaces);
        IntroduceMethodFix imf = null;
        if (viableTargets != null && !viableTargets.isEmpty()) {
            imf = new IntroduceMethodFix(info.getSnapshot().getSource(), h, params, linkedList, additionaLocalNames, TypeMirrorHandle.create((TypeMirror)returnType), returnAssignTo, declareVariableForReturnValue, exceptionHandles, exits, exitsFromAllBranches, statements[0], statements[1], duplicatesCount, scanner.getUsedTypeVars(), end, viableTargets);
            imf.setTargetIsInterface(allIfaces.get());
        }
        return imf;
    }

    static boolean isInsideSameClass(TreePath one, TreePath two) {
        Tree t;
        Object oneClass = null;
        ClassTree twoClass = null;
        while (one.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && one.getLeaf().getKind() != null) {
            t = one.getLeaf();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                oneClass = (ClassTree)t;
                break;
            }
            one = one.getParentPath();
        }
        while (two.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && two.getLeaf().getKind() != null) {
            t = two.getLeaf();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
                twoClass = (ClassTree)t;
                break;
            }
            two = two.getParentPath();
        }
        return oneClass != null && oneClass.equals(twoClass);
    }

    public static TreePathHandle validateSelectionForIntroduceMethod(CompilationInfo ci, int start, int end, int[] statementsSpan) {
        int[] span = TreeUtils.ignoreWhitespaces(ci, Math.min(start, end), Math.max(start, end));
        if ((start = span[0]) >= (end = span[1])) {
            return null;
        }
        for (TreePath tp = ci.getTreeUtilities().pathFor((start + end) / 2 + 1); tp != null; tp = tp.getParentPath()) {
            Tree leaf = tp.getLeaf();
            if (!StatementTree.class.isAssignableFrom(leaf.getKind().asInterface())) continue;
            long treeStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), leaf);
            long treeEnd = ci.getTrees().getSourcePositions().getEndPosition(ci.getCompilationUnit(), leaf);
            if (treeStart != (long)start || treeEnd != (long)end) continue;
            List<? extends StatementTree> statements = IntroduceHint.getStatements(tp);
            statementsSpan[0] = statements.indexOf(tp.getLeaf());
            statementsSpan[1] = statementsSpan[0];
            return TreePathHandle.create((TreePath)tp, (CompilationInfo)ci);
        }
        TreePath tpStart = ci.getTreeUtilities().pathFor(start);
        TreePath tpEnd = ci.getTreeUtilities().pathFor(end);
        if (tpStart.getLeaf() != tpEnd.getLeaf() || tpStart.getLeaf().getKind() != Tree.Kind.BLOCK && tpStart.getLeaf().getKind() != Tree.Kind.CASE) {
            return null;
        }
        int from = -1;
        int to = -1;
        List<? extends StatementTree> statements = tpStart.getLeaf().getKind() == Tree.Kind.BLOCK ? ((BlockTree)tpStart.getLeaf()).getStatements() : ((CaseTree)tpStart.getLeaf()).getStatements();
        int index = 0;
        for (StatementTree statementTree : statements) {
            long sStart = ci.getTrees().getSourcePositions().getStartPosition(ci.getCompilationUnit(), statementTree);
            if (sStart == (long)start && from == -1) {
                from = index;
            }
            if ((long)end < sStart && to == -1) {
                to = index - 1;
            }
            ++index;
        }
        if (from == -1) {
            return null;
        }
        if (to == -1) {
            to = statements.size() - 1;
        }
        if (to < from) {
            return null;
        }
        statementsSpan[0] = from;
        statementsSpan[1] = to;
        return TreePathHandle.create((TreePath)new TreePath(tpStart, statements.get(from)), (CompilationInfo)ci);
    }

    public IntroduceMethodFix(Source source, TreePathHandle parentBlock, List<TreePathHandle> parameters, List<TypeMirrorHandle> additionalLocalTypes, List<String> additionalLocalNames, TypeMirrorHandle returnType, TreePathHandle returnAssignTo, boolean declareVariableForReturnValue, Set<TypeMirrorHandle> thrownTypes, List<TreePathHandle> exists, boolean exitsFromAllBranches, int from, int to, int duplicatesCount, List<TreePathHandle> typeVars, int offset, Collection<TargetDescription> targets) {
        super(source, parentBlock, duplicatesCount, offset);
        this.parameters = parameters;
        this.additionalLocalTypes = additionalLocalTypes;
        this.additionalLocalNames = additionalLocalNames;
        this.returnType = returnType;
        this.returnAssignTo = returnAssignTo;
        this.declareVariableForReturnValue = declareVariableForReturnValue;
        this.thrownTypes = thrownTypes;
        this.exits = exists;
        this.exitsFromAllBranches = exitsFromAllBranches;
        this.from = from;
        this.to = to;
        this.typeVars = typeVars;
        this.targets = targets;
    }

    public String getText() {
        return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceMethod");
    }

    public String toDebugString(CompilationInfo info) {
        return "[IntroduceMethod:" + this.from + ":" + this.to + "]";
    }

    public ChangeInfo implement() throws Exception {
        JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
        JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
        btnCancel.setDefaultCapable(false);
        IntroduceMethodPanel panel = new IntroduceMethodPanel("method", this.duplicatesCount, this.targets, this.targetIsInterface);
        String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
        NotificationLineSupport notifier = dd.createNotificationLineSupport();
        MethodValidator val = new MethodValidator(this.source, this.parameters, this.returnType);
        panel.setNotifier(notifier);
        panel.setValidator(val);
        panel.setOkButton(btnOk);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
            return null;
        }
        boolean redoReferences = panel.isRefactorExisting();
        String name = panel.getMethodName();
        Set<Modifier> access = panel.getAccess();
        boolean replaceOther = panel.getReplaceOther();
        TargetDescription target = panel.getSelectedTarget();
        ModificationResult.runModificationTask(Collections.singleton(this.source), (UserTask)new TaskImpl(access, name, target, replaceOther, val.getResult(), redoReferences)).commit();
        return null;
    }

    @Override
    public ModificationResult getModificationResult() throws ParseException {
        ModificationResult result = null;
        int counter = 0;
        do {
            try {
                result = ModificationResult.runModificationTask(Collections.singleton(this.source), (UserTask)new TaskImpl(EnumSet.of(Modifier.PRIVATE), "method" + (counter != 0 ? String.valueOf(counter) : ""), this.targets.iterator().next(), true, null, false));
            }
            catch (Exception e) {
                ++counter;
            }
        } while (result == null && counter < 10);
        return result;
    }

    private class TaskImpl
    extends UserTask {
        private final Set<Modifier> access;
        private final String name;
        private final TargetDescription target;
        private final boolean replaceOther;
        WorkingCopy copy;
        TreeMaker make;
        TreePath firstStatement;
        VariableElement outcomeVariable;
        List<? extends StatementTree> statements;
        List<TreePath> statementPaths;
        List<VariableElement> parameters;
        TypeMirror returnType;
        TreePath branchExit;
        Tree returnTypeTree;
        List<TreePath> resolvedExits;
        TreePath pathToClass;
        MemberSearchResult searchResult;
        boolean redoReferences;
        private boolean returnSingleValue;
        Map<Tree, List<Integer>> replacements = new HashMap<Tree, List<Integer>>();

        public TaskImpl(Set<Modifier> access, String name, TargetDescription target, boolean replaceOther, MemberSearchResult searchResult, boolean redoReferences) {
            this.access = access;
            this.name = name;
            this.target = target;
            this.replaceOther = replaceOther;
            this.searchResult = searchResult;
            this.redoReferences = redoReferences;
        }

        private void generateMethodContents(List<StatementTree> methodStatements) {
            Iterator<TypeMirrorHandle> additionalType = IntroduceMethodFix.this.additionalLocalTypes.iterator();
            Iterator<String> additionalName = IntroduceMethodFix.this.additionalLocalNames.iterator();
            while (additionalType.hasNext() && additionalName.hasNext()) {
                TypeMirror tm = additionalType.next().resolve((CompilationInfo)this.copy);
                if (tm == null) {
                    return;
                }
                Tree type = this.make.Type(tm);
                methodStatements.add(this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)additionalName.next(), type, null));
            }
            if (IntroduceMethodFix.this.from == IntroduceMethodFix.this.to && this.statements.get(IntroduceMethodFix.this.from).getKind() == Tree.Kind.BLOCK) {
                methodStatements.addAll(((BlockTree)this.statements.get(IntroduceMethodFix.this.from)).getStatements());
            } else {
                methodStatements.addAll(this.statements.subList(IntroduceMethodFix.this.from, IntroduceMethodFix.this.to + 1));
            }
        }

        private MethodTree createMethodDefinition(boolean mustStatic) {
            List<VariableTree> formalArguments = IntroduceHint.createVariables(this.copy, this.parameters, this.pathToClass, this.statementPaths.subList(IntroduceMethodFix.this.from, IntroduceMethodFix.this.to + 1));
            if (formalArguments == null) {
                return null;
            }
            List<ExpressionTree> thrown = IntroduceHint.typeHandleToTree(this.copy, IntroduceMethodFix.this.thrownTypes);
            if (thrown == null) {
                return null;
            }
            LinkedList<TypeParameterTree> typeVars = new LinkedList<TypeParameterTree>();
            for (TreePathHandle tph : IntroduceMethodFix.this.typeVars) {
                typeVars.add((TypeParameterTree)tph.resolve((CompilationInfo)this.copy).getLeaf());
            }
            ArrayList<StatementTree> methodStatements = new ArrayList<StatementTree>();
            this.generateMethodContents(methodStatements);
            this.makeReturnsFromExtractedMethod(methodStatements);
            EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
            modifiers.addAll(this.access);
            if (this.target.iface) {
                modifiers.add(Modifier.DEFAULT);
            } else if (mustStatic) {
                modifiers.add(Modifier.STATIC);
            }
            ModifiersTree mods = this.make.Modifiers(modifiers);
            MethodTree method = this.make.Method(mods, (CharSequence)this.name, this.returnTypeTree, typeVars, formalArguments, thrown, this.make.Block(methodStatements, false), null);
            this.copy.tag(this.returnTypeTree, (Object)"typeTag");
            return method;
        }

        private void generateMethodInvocation(List<StatementTree> nueStatements, List<ExpressionTree> realArguments, Occurrence desc) {
            boolean alreadyInvoked = false;
            ExpressionTree invocation = this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)this.make.Identifier((CharSequence)this.name), realArguments);
            VariableElement remappedReturn = this.outcomeVariable;
            if (this.outcomeVariable != null) {
                ExpressionTree sel = null;
                if (desc != null) {
                    TreePath remappedTree = (TreePath)desc.getVariablesRemapToTrees().get(this.outcomeVariable);
                    VariableElement remappedElement = (VariableElement)desc.getVariablesRemapToElement().get(this.outcomeVariable);
                    if (remappedElement != null) {
                        remappedReturn = remappedElement;
                    }
                    if (remappedTree != null) {
                        sel = (ExpressionTree)remappedTree.getLeaf();
                    }
                }
                if (sel == null) {
                    sel = this.make.Identifier((CharSequence)remappedReturn.getSimpleName());
                }
                if (IntroduceMethodFix.this.declareVariableForReturnValue) {
                    nueStatements.add(this.make.Variable(this.make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)remappedReturn.getSimpleName(), this.returnTypeTree, invocation));
                    alreadyInvoked = true;
                } else if (!this.returnSingleValue) {
                    invocation = this.make.Assignment(sel, invocation);
                }
            }
            if (this.branchExit != null) {
                if (this.returnSingleValue) {
                    nueStatements.add(this.make.Return(invocation));
                } else {
                    StatementTree branch = null;
                    switch (this.branchExit.getLeaf().getKind()) {
                        case BREAK: {
                            branch = this.make.Break((CharSequence)((BreakTree)this.branchExit.getLeaf()).getLabel());
                            break;
                        }
                        case CONTINUE: {
                            branch = this.make.Continue((CharSequence)((ContinueTree)this.branchExit.getLeaf()).getLabel());
                            break;
                        }
                        case RETURN: {
                            branch = this.make.Return(((ReturnTree)this.branchExit.getLeaf()).getExpression());
                        }
                    }
                    if (remappedReturn != null || IntroduceMethodFix.this.exitsFromAllBranches) {
                        nueStatements.add(this.make.ExpressionStatement(invocation));
                        nueStatements.add(branch);
                    } else {
                        nueStatements.add(this.make.If((ExpressionTree)this.make.Parenthesized(invocation), branch, null));
                    }
                }
                alreadyInvoked = true;
            }
            if (!alreadyInvoked) {
                nueStatements.add(this.make.ExpressionStatement(invocation));
            }
        }

        private ReturnTree makeExtractedReturn(boolean forceReturn) {
            if (this.outcomeVariable != null) {
                return this.make.Return((ExpressionTree)this.make.Identifier((CharSequence)this.outcomeVariable.getSimpleName()));
            }
            if (forceReturn) {
                return this.make.Return(IntroduceMethodFix.this.exitsFromAllBranches ? null : this.make.Literal((Object)true));
            }
            return null;
        }

        private void makeReturnsFromExtractedMethod(List<StatementTree> methodStatements) {
            if (this.returnSingleValue) {
                return;
            }
            if (this.resolvedExits != null) {
                for (TreePath resolved : this.resolvedExits) {
                    ReturnTree r = this.makeExtractedReturn(true);
                    GeneratorUtilities.get((WorkingCopy)this.copy).copyComments(resolved.getLeaf(), (Tree)r, false);
                    GeneratorUtilities.get((WorkingCopy)this.copy).copyComments(resolved.getLeaf(), (Tree)r, true);
                    this.copy.rewrite(resolved.getLeaf(), (Tree)r);
                }
                if (this.outcomeVariable == null && !IntroduceMethodFix.this.exitsFromAllBranches) {
                    methodStatements.add(this.make.Return((ExpressionTree)this.make.Literal((Object)false)));
                }
            } else {
                ReturnTree ret = this.makeExtractedReturn(false);
                if (ret != null) {
                    methodStatements.add(ret);
                }
            }
        }

        private boolean resolveAndInitialize() {
            this.firstStatement = IntroduceMethodFix.this.handle.resolve((CompilationInfo)this.copy);
            this.returnType = IntroduceMethodFix.this.returnType.resolve((CompilationInfo)this.copy);
            if (this.firstStatement == null || this.returnType == null) {
                return false;
            }
            this.parameters = IntroduceHint.resolveVariables((CompilationInfo)this.copy, IntroduceMethodFix.this.parameters);
            if (IntroduceMethodFix.this.returnAssignTo != null) {
                this.outcomeVariable = (VariableElement)IntroduceMethodFix.this.returnAssignTo.resolveElement((CompilationInfo)this.copy);
                if (this.outcomeVariable == null) {
                    return false;
                }
            }
            if (IntroduceMethodFix.this.exits != null && !IntroduceMethodFix.this.exits.isEmpty()) {
                this.branchExit = IntroduceMethodFix.this.exits.iterator().next().resolve((CompilationInfo)this.copy);
                if (this.branchExit == null) {
                    return false;
                }
                this.resolvedExits = new ArrayList<TreePath>(IntroduceMethodFix.this.exits.size());
                for (TreePathHandle h : IntroduceMethodFix.this.exits) {
                    TreePath resolved = h.resolve((CompilationInfo)this.copy);
                    if (resolved == null) {
                        return false;
                    }
                    if (this.resolvedExits.isEmpty()) {
                        this.branchExit = resolved;
                    }
                    this.resolvedExits.add(resolved);
                }
                this.returnSingleValue = IntroduceMethodFix.this.exitsFromAllBranches && this.branchExit.getLeaf().getKind() == Tree.Kind.RETURN && this.outcomeVariable == null && this.returnType.getKind() != TypeKind.VOID;
            }
            this.make = this.copy.getTreeMaker();
            this.returnTypeTree = this.make.Type(this.returnType);
            this.statementPaths = Utilities.getStatementPaths(this.firstStatement);
            this.statements = IntroduceHint.getStatements(this.firstStatement);
            GeneratorUtilities.get((WorkingCopy)this.copy).importComments(this.firstStatement.getParentPath().getLeaf(), this.copy.getCompilationUnit());
            return true;
        }

        void addReplacement(Tree parent, int start, int end) {
            List<Integer> rr = this.replacements.get(parent);
            if (rr == null) {
                rr = new ArrayList<Integer>();
                this.replacements.put(parent, rr);
            }
            rr.add(start);
            rr.add(end);
        }

        boolean isDuplicateValid(TreePath duplicateRoot) {
            TreePath parent = duplicateRoot.getParentPath();
            List<Integer> repls = this.replacements.get(parent.getLeaf());
            if (repls == null) {
                return true;
            }
            List<? extends StatementTree> stmts = IntroduceHint.getStatements(duplicateRoot);
            int o = stmts.indexOf(duplicateRoot.getLeaf());
            int l = repls.size();
            for (int idx = 0; idx < l; idx += 2) {
                if (o < repls.get(idx) || o > repls.get(idx + 1)) continue;
                return false;
            }
            return true;
        }

        List<ExpressionTree> makeArgumentsForDuplicate(Occurrence desc) {
            LinkedList<Union2<VariableElement, TreePath>> dupeParameters = new LinkedList<Union2<VariableElement, TreePath>>();
            for (VariableElement ve : this.parameters) {
                if (desc.getVariablesRemapToTrees().containsKey(ve)) {
                    dupeParameters.add((Union2<VariableElement, TreePath>)Union2.createSecond((Object)((TreePath)desc.getVariablesRemapToTrees().get(ve))));
                    continue;
                }
                dupeParameters.add((Union2<VariableElement, TreePath>)Union2.createFirst((Object)ve));
            }
            List<ExpressionTree> dupeRealArguments = IntroduceHint.realArgumentsForTrees(this.make, dupeParameters);
            return dupeRealArguments;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
            copy.toPhase(JavaSource.Phase.RESOLVED);
            this.copy = copy;
            if (!this.resolveAndInitialize()) {
                return;
            }
            IdentityHashMap rewritten = new IdentityHashMap();
            InstanceRefFinder finder = new InstanceRefFinder((CompilationInfo)copy, this.firstStatement);
            for (TreePath stp : this.statementPaths) {
                finder.process(stp);
            }
            if (finder.containsLocalReferences()) {
                NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)Bundle.MSG_ExpressionContainsLocalReferences(), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)dd);
                return;
            }
            TypeElement targetType = (TypeElement)this.target.type.resolve((CompilationInfo)copy);
            TreePath treePath = this.pathToClass = targetType != null ? copy.getTrees().getPath(targetType) : null;
            if (this.pathToClass == null) {
                this.pathToClass = TreeUtils.findClass(this.firstStatement);
            }
            assert (this.pathToClass != null);
            boolean referencesInstances = finder.containsInstanceReferences();
            boolean isStatic = IntroduceHint.needsStaticRelativeTo((CompilationInfo)copy, this.pathToClass, this.firstStatement);
            LinkedList<StatementTree> nueStatements = new LinkedList<StatementTree>();
            this.generateMethodInvocation(nueStatements, IntroduceHint.realArguments(this.make, this.parameters), null);
            Utilities.replaceStatements(copy, this.firstStatement, this.statements.get(IntroduceMethodFix.this.to), nueStatements);
            this.addReplacement(this.firstStatement.getParentPath().getLeaf(), IntroduceMethodFix.this.from, IntroduceMethodFix.this.to);
            if (this.replaceOther) {
                Document doc = copy.getDocument();
                LinkedList<TreePath> statementsPaths = new LinkedList<TreePath>();
                for (StatementTree statementTree : this.statements.subList(IntroduceMethodFix.this.from, IntroduceMethodFix.this.to + 1)) {
                    statementsPaths.add(new TreePath(this.firstStatement.getParentPath(), statementTree));
                }
                Pattern p = Pattern.createPatternWithRemappableVariables(statementsPaths, this.parameters, (boolean)true);
                ArrayList<Occurrence> arrayList = new ArrayList<Occurrence>(Matcher.create((CompilationInfo)copy).setSearchRoot(this.pathToClass).setCancel(new AtomicBoolean()).match(p));
                arrayList.sort(new OccurrencePositionComparator(copy.getCompilationUnit(), copy.getTrees().getSourcePositions()));
                for (Occurrence desc : arrayList) {
                    TreePath firstLeaf = desc.getOccurrenceRoot();
                    if (!this.isDuplicateValid(firstLeaf)) continue;
                    Tree mapped = copy.resolveRewriteTarget(firstLeaf.getParentPath().getLeaf());
                    TreePath mappedPath = new TreePath(new TreePath(firstLeaf.getParentPath().getParentPath(), mapped), firstLeaf.getLeaf());
                    List<? extends StatementTree> parentStatements = IntroduceHint.getStatements(mappedPath);
                    int dupeStart = parentStatements.indexOf(firstLeaf.getLeaf());
                    assert (dupeStart > -1);
                    int dupeLast = dupeStart + statementsPaths.size() - 1;
                    StatementTree firstSt = (StatementTree)firstLeaf.getLeaf();
                    StatementTree lastSt = parentStatements.get(dupeLast);
                    TreePath enclosingMethod = TreeUtils.findMethod(firstLeaf);
                    if (enclosingMethod == null) continue;
                    ScanStatement scanner = IntroduceMethodFix.createAndRunScanner((CompilationInfo)copy, enclosingMethod, firstSt, lastSt, new AtomicBoolean(false));
                    boolean usedAfter = false;
                    if (!scanner.usedAfterSelection.isEmpty()) {
                        usedAfter = true;
                        if (scanner.usedAfterSelection.size() == 1 && this.outcomeVariable != null) {
                            VariableElement usedVar = scanner.usedAfterSelection.keySet().iterator().next();
                            Element remapped = (Element)desc.getVariablesRemapToElement().get(this.outcomeVariable);
                            if (remapped == null || remapped == usedVar) {
                                usedAfter = false;
                            }
                        }
                    }
                    int startOff = (int)copy.getTrees().getSourcePositions().getStartPosition(copy.getCompilationUnit(), firstSt);
                    int endOff = (int)copy.getTrees().getSourcePositions().getEndPosition(copy.getCompilationUnit(), lastSt);
                    if (usedAfter || !GraphicsEnvironment.isHeadless() && !IntroduceHint.shouldReplaceDuplicate(doc, startOff, endOff)) continue;
                    LinkedList<StatementTree> newStatements = new LinkedList<StatementTree>();
                    this.generateMethodInvocation(newStatements, this.makeArgumentsForDuplicate(desc), desc);
                    Utilities.replaceStatements(copy, mappedPath, lastSt, newStatements);
                    this.addReplacement(firstLeaf.getParentPath().getLeaf(), dupeStart, dupeLast);
                    isStatic |= IntroduceHint.needsStaticRelativeTo((CompilationInfo)copy, this.pathToClass, firstLeaf);
                }
                IntroduceHint.introduceBag(doc).clear();
            }
            MethodTree method = this.createMethodDefinition(isStatic &= !referencesInstances & this.target.canStatic);
            ClassTree nueClass = IntroduceHint.INSERT_CLASS_MEMBER.insertClassMember(copy, (ClassTree)this.pathToClass.getLeaf(), method, IntroduceMethodFix.this.offset);
            copy.rewrite(this.pathToClass.getLeaf(), (Tree)nueClass);
            if (this.redoReferences) {
                new ReferenceTransformer(copy, ElementKind.METHOD, this.searchResult, this.name, targetType).scan(this.pathToClass, null);
            }
        }
    }

    static class OccurrencePositionComparator
    implements Comparator<Occurrence> {
        final CompilationUnitTree cut;
        final SourcePositions positions;

        public OccurrencePositionComparator(CompilationUnitTree cut, SourcePositions positions) {
            this.cut = cut;
            this.positions = positions;
        }

        @Override
        public int compare(Occurrence o1, Occurrence o2) {
            Tree r1 = o1.getOccurrenceRoot().getLeaf();
            Tree r2 = o2.getOccurrenceRoot().getLeaf();
            int p1 = (int)this.positions.getStartPosition(this.cut, r1);
            int p2 = (int)this.positions.getStartPosition(this.cut, r2);
            return p1 - p2;
        }
    }
}

