/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.values;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lsp.InlineValue;
import org.netbeans.api.lsp.Range;
import org.netbeans.modules.debugger.jpda.ui.values.ComputeInlineValues;
import org.netbeans.spi.lsp.InlineValuesProvider;
import org.openide.filesystems.FileObject;

public final class InlineValueProviderImpl
implements InlineValuesProvider {
    public CompletableFuture<List<? extends InlineValue>> inlineValues(FileObject file, int currentExecutionPosition) {
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        CompletableFuture<List<? extends InlineValue>> result = new CompletableFuture<List<? extends InlineValue>>();
        ArrayList resultValues = new ArrayList();
        if (js != null) {
            try {
                js.runUserActionTask(cc -> {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    int stackLine = (int)cc.getCompilationUnit().getLineMap().getLineNumber(currentExecutionPosition);
                    int stackCol = (int)cc.getCompilationUnit().getLineMap().getColumnNumber(currentExecutionPosition);
                    for (ComputeInlineValues.InlineVariable var : ComputeInlineValues.computeVariables((CompilationInfo)cc, stackLine, stackCol, new AtomicBoolean())) {
                        resultValues.add(InlineValue.createInlineVariable((Range)new Range(var.start(), var.end()), (String)var.expression()));
                    }
                }, true);
            }
            catch (IOException ex) {
                result.completeExceptionally(ex);
                return result;
            }
        }
        result.complete(resultValues);
        return result;
    }
}

