/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class GraphUtils {
    public static <D, N extends TarjanNode<D, N>> List<? extends List<? extends N>> tarjan(Iterable<? extends N> nodes) {
        Tarjan tarjan = new Tarjan();
        return tarjan.findSCC(nodes);
    }

    public static <D, N extends DottableNode<D, N>> String toDot(Collection<? extends N> nodes, String name, String header) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("digraph %s {\n", name));
        buf.append(String.format("label = %s;\n", DotVisitor.wrap(header)));
        DotVisitor dotVisitor = new DotVisitor();
        dotVisitor.visit((Collection)nodes, buf);
        buf.append("}\n");
        return buf.toString();
    }

    private static class Tarjan<D, N extends TarjanNode<D, N>> {
        int index = 0;
        ListBuffer<List<N>> sccs = new ListBuffer();
        ListBuffer<N> stack = new ListBuffer();

        private Tarjan() {
        }

        private List<? extends List<? extends N>> findSCC(Iterable<? extends N> nodes) {
            for (TarjanNode node : nodes) {
                if (node.index != -1) continue;
                this.findSCC(node);
            }
            return this.sccs.toList();
        }

        private void findSCC(N v) {
            this.visitNode(v);
            for (TarjanNode n : ((TarjanNode)v).getAllDependencies()) {
                if (n.index == -1) {
                    this.findSCC(n);
                    ((TarjanNode)v).lowlink = Math.min(((TarjanNode)v).lowlink, n.lowlink);
                    continue;
                }
                if (!this.stack.contains(n)) continue;
                ((TarjanNode)v).lowlink = Math.min(((TarjanNode)v).lowlink, n.index);
            }
            if (((TarjanNode)v).lowlink == ((TarjanNode)v).index) {
                this.addSCC(v);
            }
        }

        private void visitNode(N n) {
            ((TarjanNode)n).index = this.index;
            ((TarjanNode)n).lowlink = this.index++;
            this.stack.prepend(n);
            ((TarjanNode)n).active = true;
        }

        private void addSCC(N v) {
            TarjanNode n;
            ListBuffer<TarjanNode> cycle = new ListBuffer<TarjanNode>();
            do {
                n = (TarjanNode)this.stack.remove();
                n.active = false;
                cycle.add(n);
            } while (n != v);
            this.sccs.add(cycle.toList());
        }
    }

    public static class DotVisitor<D, N extends DottableNode<D, N>>
    extends NodeVisitor<D, N, StringBuilder> {
        @Override
        public void visitDependency(DependencyKind dk, N from, N to, StringBuilder buf) {
            buf.append(String.format("%s -> %s", from.hashCode(), to.hashCode()));
            buf.append(this.formatProperties(from.dependencyAttributes(to, dk)));
            buf.append('\n');
        }

        @Override
        public void visitNode(N node, StringBuilder buf) {
            buf.append(String.format("%s ", node.hashCode()));
            buf.append(this.formatProperties(node.nodeAttributes()));
            buf.append('\n');
        }

        protected String formatProperties(Properties p) {
            return p.toString().replace(',', ' ').replace('{', '[').replace('}', ']');
        }

        protected static String wrap(String s) {
            String res = "\"" + s + "\"";
            return res.replaceAll("\n", "");
        }
    }

    public static abstract class TarjanNode<D, N extends TarjanNode<D, N>>
    extends AbstractNode<D, N>
    implements Comparable<N> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D data) {
            super(data);
        }

        public abstract Iterable<? extends N> getAllDependencies();

        @Override
        public int compareTo(N o) {
            return Integer.compare(this.index, ((TarjanNode)o).index);
        }
    }

    public static abstract class AbstractNode<D, N extends AbstractNode<D, N>>
    implements Node<D, N> {
        public final D data;

        public AbstractNode(D data) {
            this.data = data;
        }

        public abstract DependencyKind[] getSupportedDependencyKinds();

        public abstract Collection<? extends N> getDependenciesByKind(DependencyKind var1);

        public String toString() {
            return this.data.toString();
        }

        @Override
        public <A> void accept(NodeVisitor<D, N, A> visitor, A arg) {
            visitor.visitNode(this, arg);
            for (DependencyKind dk : this.getSupportedDependencyKinds()) {
                for (AbstractNode dep : new ArrayList<N>(this.getDependenciesByKind(dk))) {
                    visitor.visitDependency(dk, this, dep, arg);
                }
            }
        }
    }

    public static interface DottableNode<D, N extends DottableNode<D, N>>
    extends Node<D, N> {
        public Properties nodeAttributes();

        public Properties dependencyAttributes(N var1, DependencyKind var2);
    }

    static abstract class NodeVisitor<D, N extends Node<D, N>, A> {
        NodeVisitor() {
        }

        public abstract void visitNode(N var1, A var2);

        public abstract void visitDependency(DependencyKind var1, N var2, N var3, A var4);

        public void visit(Collection<? extends N> nodes, A arg) {
            for (Node n : new ArrayList<N>(nodes)) {
                n.accept(this, arg);
            }
        }
    }

    public static interface Node<D, N extends Node<D, N>> {
        public <A> void accept(NodeVisitor<D, N, A> var1, A var2);
    }

    public static interface DependencyKind {
    }
}

