/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.browsers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript.karma.browsers.Browser;
import org.netbeans.modules.javascript.karma.browsers.ChromeBased;
import org.netbeans.modules.javascript.karma.browsers.Firefox;
import org.netbeans.modules.javascript.karma.browsers.OperaLegacy;

public final class Browsers {
    private static final Logger LOGGER = Logger.getLogger(Browsers.class.getName());
    private static final Map<String, List<Browser>> BROWSERS;
    private static final List<String> SILENT_BROWSERS;

    private Browsers() {
    }

    public static Collection<Browser> getBrowsers(String ... identifiers) {
        return Browsers.getBrowsers(Arrays.asList(identifiers));
    }

    public static Collection<Browser> getBrowsers(List<String> identifiers) {
        HashSet<Browser> result = new HashSet<Browser>();
        for (String identifier : identifiers) {
            if (SILENT_BROWSERS.contains(identifier)) continue;
            List<Browser> browsers = BROWSERS.get(identifier);
            if (browsers == null) {
                LOGGER.log(Level.INFO, "Unknown karma browser: {0}", identifier);
                continue;
            }
            result.addAll(browsers);
        }
        return result;
    }

    static {
        SILENT_BROWSERS = Arrays.asList("IE", "Safari", "PhantomJS");
        List<Browser> allBrowsers = Arrays.asList(new ChromeBased(), new Firefox(), new OperaLegacy());
        BROWSERS = new ConcurrentHashMap<String, List<Browser>>();
        for (Browser browser : allBrowsers) {
            for (String identifier : browser.getIdentifiers()) {
                List<Browser> browsers = BROWSERS.get(identifier);
                if (browsers == null) {
                    browsers = new CopyOnWriteArrayList<Browser>();
                    BROWSERS.put(identifier, browsers);
                }
                browsers.add(browser);
            }
        }
    }
}

