/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.io.File;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class BasePathSupport {
    public static String getAntPropertyName(String property) {
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return property.substring(2, property.length() - 1);
        }
        return property;
    }

    public static final class Item {
        private final Type type;
        private final String filePath;
        private final boolean broken;
        protected String property;

        private Item(Type type, String filePath, String property, boolean broken) {
            this.type = type;
            this.filePath = filePath;
            this.property = property;
            this.broken = broken;
        }

        public static Item create(String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(Type.CLASSPATH, null, property, false);
        }

        public static Item create(String filePath, String property) {
            if (filePath == null) {
                throw new IllegalArgumentException("filePath must not be null");
            }
            return new Item(Type.FOLDER, filePath, property, false);
        }

        public static Item createBroken(String filePath, String property) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(Type.FOLDER, filePath, property, true);
        }

        public Type getType() {
            return this.type;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getAbsoluteFilePath(FileObject baseFolder) {
            File file = new File(this.filePath);
            if (file.isAbsolute()) {
                return file.getAbsolutePath();
            }
            return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)baseFolder), (String)this.filePath).getAbsolutePath();
        }

        public FileObject getFileObject(FileObject baseFolder) {
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.getAbsoluteFilePath(baseFolder))));
        }

        public String getReference() {
            return this.property;
        }

        public boolean isBroken() {
            return this.broken;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(200);
            sb.append("BaseIncludePathSupport.Item[ type: ");
            sb.append(this.type.name());
            sb.append(", filePath: ");
            sb.append(this.filePath);
            sb.append(", property: ");
            sb.append(this.property);
            sb.append(", broken: ");
            sb.append(this.broken);
            sb.append(" ]");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.broken != other.broken) {
                return false;
            }
            switch (this.getType()) {
                case CLASSPATH: {
                    if (this.property == other.property || this.property != null && this.property.equals(other.property)) break;
                    return false;
                }
                default: {
                    if (this.filePath == other.filePath || this.filePath != null && this.filePath.equals(other.filePath)) break;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            if (this.broken) {
                return 42;
            }
            int hash = this.getType().ordinal();
            switch (this.getType()) {
                case CLASSPATH: {
                    hash += this.property.hashCode();
                    break;
                }
                default: {
                    hash = 41 * hash + (this.filePath != null ? this.filePath.hashCode() : 0);
                }
            }
            return hash;
        }

        public static enum Type {
            CLASSPATH,
            FOLDER;

        }
    }
}

