/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.util.HashMap;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodePanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public abstract class SectionNodeView
extends SectionView {
    private final XmlMultiViewDataObject dataObject;
    private SectionNode rootNode = null;
    private HashMap<SectionNode, SectionNode> nodes = new HashMap();
    private final RequestProcessor.Task refreshTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            SectionNodeView.this.getRootNode().refreshSubtree();
        }
    });
    private static final int REFRESH_DELAY = 20;

    public SectionNodeView(XmlMultiViewDataObject dataObject) {
        this.dataObject = dataObject;
    }

    public void setRootNode(SectionNode rootNode) {
        this.rootNode = rootNode;
        Children.Array root = new Children.Array();
        root.add(new Node[]{rootNode});
        AbstractNode mainNode = new AbstractNode((Children)root);
        mainNode.setDisplayName(rootNode.getDisplayName());
        mainNode.setIconBaseWithExtension(rootNode.getIconBase() + ".gif");
        this.setRoot((Node)mainNode);
        this.addSection(rootNode.getSectionNodePanel());
    }

    public XmlMultiViewDataObject getDataObject() {
        return this.dataObject;
    }

    @Override
    public void openSection(Node node) {
        this.openPanel(node);
    }

    @Override
    public void openPanel(Object key) {
        SectionNode sectionNode = this.retrieveSectionNode((SectionNode)((Object)key));
        SectionNodePanel sectionNodePanel = sectionNode.getSectionNodePanel();
        sectionNodePanel.open();
        this.setActivePanel(sectionNodePanel);
        sectionNodePanel.setActive(true);
        this.selectNode(sectionNodePanel.getNode());
        Utils.scrollToVisible(sectionNodePanel);
    }

    public SectionNode getRootNode() {
        return this.rootNode;
    }

    public void registerNode(SectionNode node) {
        this.nodes.put(node, node);
    }

    public SectionNode retrieveSectionNode(SectionNode node) {
        SectionNode sectionNode = this.nodes.get((Object)node);
        return sectionNode == null ? this.rootNode : sectionNode;
    }

    public void refreshView() {
        this.rootNode.refreshSubtree();
    }

    public void scheduleRefreshView() {
        this.refreshTask.schedule(20);
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        this.rootNode.dataModelPropertyChange(source, propertyName, oldValue, newValue);
    }

    public abstract XmlMultiViewDataSynchronizer getModelSynchronizer();
}

