/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs.ui.logicalview;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.LibraryListener;
import org.netbeans.modules.javascript.cdnjs.LibraryPersistence;
import org.netbeans.modules.javascript.cdnjs.LibraryUtils;
import org.netbeans.modules.javascript.cdnjs.ui.logicalview.Bundle;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public final class CdnjsLibraries {
    private CdnjsLibraries() {
    }

    public static NodeFactory forHtml5Project() {
        return new CdnjsLibrariesNodeFactory();
    }

    public static NodeFactory forPhpProject() {
        return new CdnjsLibrariesNodeFactory();
    }

    public static NodeFactory forWebProject() {
        return new CdnjsLibrariesNodeFactory();
    }

    public static NodeFactory forMavenProject() {
        return new CdnjsLibrariesNodeFactory();
    }

    private static final class CdnjsLibrariesNodeFactory
    implements NodeFactory {
        private CdnjsLibrariesNodeFactory() {
        }

        public NodeList<?> createNodes(Project project) {
            assert (project != null);
            return new CdnjsLibrariesNodeList(project);
        }
    }

    private static final class CustomizeLibrariesAction
    extends AbstractAction {
        private final Project project;

        CustomizeLibrariesAction(Project project) {
            assert (project != null);
            this.project = project;
            String name = Bundle.CustomizeLibrariesAction_name();
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer("CDNJS", null);
        }
    }

    private static final class CdnjsLibraryNode
    extends AbstractNode {
        private static final String LIBRARIES_ICON = "org/netbeans/modules/javascript/cdnjs/ui/resources/libraries.gif";
        private static final String BROKEN_BADGE = "org/netbeans/modules/javascript/cdnjs/ui/resources/broken-badge.gif";
        private final Project project;
        private final Library.Version library;

        CdnjsLibraryNode(Project project, Library.Version library) {
            super(Children.LEAF);
            assert (project != null);
            assert (library != null);
            this.project = project;
            this.library = library;
        }

        public String getName() {
            return this.library.getLibrary().getName();
        }

        public String getShortDescription() {
            if (LibraryUtils.isBroken(this.project, this.library)) {
                return Bundle.CdnjsLibraryNode_description_broken(this.getName(), this.library.getName());
            }
            return Bundle.CdnjsLibraryNode_description(this.getName(), this.library.getName());
        }

        public Image getIcon(int type) {
            return this.getIcon();
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon();
        }

        private Image getIcon() {
            Image icon = ImageUtilities.loadImage((String)LIBRARIES_ICON, (boolean)false);
            if (LibraryUtils.isBroken(this.project, this.library)) {
                return ImageUtilities.mergeImages((Image)icon, (Image)ImageUtilities.loadImage((String)BROKEN_BADGE, (boolean)false), (int)0, (int)7);
            }
            return ImageUtilities.loadImage((String)LIBRARIES_ICON, (boolean)false);
        }

        public Action[] getActions(boolean context) {
            return new Action[0];
        }
    }

    private static final class CdnjsLibrariesChildren
    extends Children.Keys<Library.Version> {
        private final Project project;

        CdnjsLibrariesChildren(Project project) {
            super(true);
            assert (project != null);
            this.project = project;
        }

        public boolean hasLibraries() {
            return LibraryPersistence.getDefault().loadLibraries(this.project).length > 0;
        }

        public void refreshLibraries() {
            this.setKeys();
        }

        protected Node[] createNodes(Library.Version key) {
            return new Node[]{new CdnjsLibraryNode(this.project, key)};
        }

        protected void addNotify() {
            this.setKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        private void setKeys() {
            Library.Version[] libraries = LibraryPersistence.getDefault().loadLibraries(this.project);
            if (libraries.length == 0) {
                this.setKeys(Collections.emptyList());
                return;
            }
            this.setKeys(Arrays.asList(libraries));
        }
    }

    private static final class CdnjsLibrariesNode
    extends AbstractNode {
        private static final String LIBRARIES_BADGE = "org/netbeans/modules/javascript/cdnjs/ui/resources/libraries-badge.png";
        private final Project project;
        private final Node iconDelegate;

        CdnjsLibrariesNode(Project project, CdnjsLibrariesChildren cdnjsLibrariesChildren) {
            super((Children)cdnjsLibrariesChildren);
            assert (project != null);
            this.project = project;
            this.iconDelegate = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
        }

        public String getDisplayName() {
            return Bundle.CdnjsLibrariesNode_name();
        }

        public Image getIcon(int type) {
            return ImageUtilities.mergeImages((Image)this.iconDelegate.getIcon(type), (Image)ImageUtilities.loadImage((String)LIBRARIES_BADGE), (int)7, (int)7);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{new CustomizeLibrariesAction(this.project)};
        }
    }

    private static final class CdnjsLibrariesNodeList
    implements NodeList<Node>,
    LibraryListener,
    FileChangeListener {
        private final Project project;
        private final CdnjsLibrariesChildren cdnjsLibrariesChildren;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Node cdnjsLibrariesNode;

        CdnjsLibrariesNodeList(Project project) {
            assert (project != null);
            this.project = project;
            this.cdnjsLibrariesChildren = new CdnjsLibrariesChildren(project);
        }

        public List<Node> keys() {
            if (!this.cdnjsLibrariesChildren.hasLibraries()) {
                return Collections.emptyList();
            }
            if (this.cdnjsLibrariesNode == null) {
                this.cdnjsLibrariesNode = new CdnjsLibrariesNode(this.project, this.cdnjsLibrariesChildren);
            }
            return Collections.singletonList(this.cdnjsLibrariesNode);
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        public Node node(Node key) {
            return key;
        }

        public void addNotify() {
            LibraryPersistence libraryPersistence = LibraryPersistence.getDefault();
            libraryPersistence.addLibraryListener((LibraryListener)WeakListeners.create(LibraryListener.class, (EventListener)this, (Object)libraryPersistence));
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)new File(LibraryUtils.getWebRoot(this.project), LibraryUtils.getLibraryFolder(this.project)));
        }

        public void removeNotify() {
        }

        @Override
        public void librariesChanged(Project project) {
            if (project.equals(this.project)) {
                this.fireChange();
            }
        }

        private void fireChange() {
            this.cdnjsLibrariesChildren.refreshLibraries();
            this.changeSupport.fireChange();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

