/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.Dimension;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.ui.CommonPasswordPanel;
import org.netbeans.modules.glassfish.common.ui.GlassFishPassword;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GlassFishCredentials
extends CommonPasswordPanel {
    private static final Logger LOGGER = GlassFishLogger.get(GlassFishCredentials.class);
    private JLabel messageLabel;
    private JPasswordField password;
    private JLabel passwordLabel;
    private JLabel userLabel;
    private JTextField userText;

    public static boolean setCredentials(GlassfishInstance instance, String message) {
        String title = NbBundle.getMessage(GlassFishPassword.class, (String)"GlassFishCredentials.title");
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor(null, title, 2, -1, null, null);
        GlassFishCredentials panel = new GlassFishCredentials(notifyDescriptor, instance, message);
        Object button = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (button == NotifyDescriptor.CANCEL_OPTION) {
            return false;
        }
        String userName = panel.getUserName();
        String password = panel.getPassword();
        instance.setAdminUser(userName);
        instance.setAdminPassword(password);
        try {
            GlassfishInstance.writeInstanceToFile(instance);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Could not store GlassFish server attributes", ex);
        }
        return true;
    }

    public static boolean setCredentials(GlassfishInstance instance) {
        String message = NbBundle.getMessage(GlassFishPassword.class, (String)"GlassFishCredentials.message", (Object)instance.getDisplayName());
        return GlassFishCredentials.setCredentials(instance, message);
    }

    public GlassFishCredentials(NotifyDescriptor descriptor, GlassfishInstance instance, String message) {
        super(descriptor, instance, message);
        this.initComponents();
        this.initFileds(true);
    }

    String getPassword() {
        return new String(this.password.getPassword());
    }

    String getUserName() {
        return this.userText.getText();
    }

    public void clear() {
        this.password.setText("");
        this.userText.setText("");
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.userLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.userText = new JTextField();
        this.password = new JPasswordField();
        this.setMaximumSize(new Dimension(500, 200));
        this.setMinimumSize(new Dimension(500, 150));
        this.setPreferredSize(new Dimension(500, 150));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)this.message);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)this.userLabelText);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)this.passwordLabelText);
        this.userText.setText(this.instance.getAdminUser());
        this.password.setText(this.instance.getAdminPassword());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.passwordLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.userLabel, GroupLayout.Alignment.LEADING, -1, 150, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userText, -1, 314, Short.MAX_VALUE).addComponent(this.password)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.userText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.password, -2, -1, -2)).addContainerGap(65, Short.MAX_VALUE)));
    }
}

