/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Date;
import org.netbeans.modules.diff.tree.Bundle;
import org.netbeans.modules.diff.tree.TreeEntry;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.ProxyLookup;

public class TreeEntryNode
extends AbstractNode {
    private final TreeEntry te;

    public static TreeEntryNode create(TreeEntry bean) {
        try {
            ArrayList<Lookup> proxyLookup = new ArrayList<Lookup>(2);
            if (bean.getFile2() != null) {
                proxyLookup.add(bean.getFile2().getLookup());
            }
            return new TreeEntryNode(bean, (Lookup)new ProxyLookup((Lookup[])proxyLookup.toArray(Lookup[]::new)));
        }
        catch (IntrospectionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private TreeEntryNode(TreeEntry bean, Lookup lkp) throws IntrospectionException {
        super(Children.LEAF, lkp);
        this.te = bean;
        this.setDisplayName(bean.getName());
        this.setName(bean.getRelativePath());
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set props = sheet.get("properties");
        if (props == null) {
            props = Sheet.createPropertiesSet();
            sheet.put(props);
        }
        props.put((Node.Property)new PropertySupport.Name((Node)this));
        props.put((Node.Property)new Filename());
        props.put((Node.Property)new RelativeName());
        props.put((Node.Property)new IsIdentical());
        props.put((Node.Property)new Path1());
        props.put((Node.Property)new Path2());
        props.put((Node.Property)new Modtime1());
        props.put((Node.Property)new Modtime2());
        return sheet;
    }

    private class Filename
    extends PropertySupport.ReadOnly<String> {
        public Filename() {
            super("filename", String.class, Bundle.PROP_filename(), "");
        }

        public String getValue() {
            return TreeEntryNode.this.te.getName();
        }
    }

    private class RelativeName
    extends PropertySupport.ReadOnly<String> {
        public RelativeName() {
            super("relativePath", String.class, Bundle.PROP_relativePath(), "");
        }

        public String getValue() {
            return TreeEntryNode.this.te.getRelativePath();
        }
    }

    private class IsIdentical
    extends PropertySupport.ReadOnly<Boolean> {
        public IsIdentical() {
            super("identical", Boolean.class, Bundle.PROP_identical(), "");
        }

        public Boolean getValue() {
            return TreeEntryNode.this.te.isFilesIdentical();
        }
    }

    private class Path1
    extends PropertySupport.ReadOnly<String> {
        public Path1() {
            super("path1", String.class, Bundle.PROP_path1(), "");
        }

        public String getValue() {
            return TreeEntryNode.this.te.getFile1() != null ? TreeEntryNode.this.te.getFile1().getPath() : null;
        }
    }

    private class Path2
    extends PropertySupport.ReadOnly<String> {
        public Path2() {
            super("path2", String.class, Bundle.PROP_path2(), "");
        }

        public String getValue() {
            return TreeEntryNode.this.te.getFile2() != null ? TreeEntryNode.this.te.getFile2().getPath() : null;
        }
    }

    private class Modtime1
    extends PropertySupport.ReadOnly<Date> {
        public Modtime1() {
            super("modtime1", Date.class, Bundle.PROP_modtime1(), "");
        }

        public Date getValue() {
            return TreeEntryNode.this.te.getFile1() != null ? TreeEntryNode.this.te.getFile1().lastModified() : null;
        }
    }

    private class Modtime2
    extends PropertySupport.ReadOnly<Date> {
        public Modtime2() {
            super("modtime2", Date.class, Bundle.PROP_modtime2(), "");
        }

        public Date getValue() {
            return TreeEntryNode.this.te.getFile2() != null ? TreeEntryNode.this.te.getFile2().lastModified() : null;
        }
    }
}

