/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.notifications.filter.CategoryFilter;
import org.netbeans.modules.notifications.filter.CateogoriesPanel;
import org.netbeans.modules.notifications.filter.FilterRepository;
import org.netbeans.modules.notifications.filter.NotificationFilter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FilterEditor
extends JPanel
implements PropertyChangeListener {
    static final String PROP_VALUE_VALID = "filterValueValid";
    private final HashMap<CategoryFilter, CateogoriesPanel> filter2types = new HashMap(10);
    private final FilterRepository filterRepository;
    private final FilterModel filterModel;
    private JButton btnOk;
    private JButton btnCancel;
    private JButton btnNewFilter;
    private JButton btnRemoveFilter;
    private JLabel lblFilterName;
    private JLabel lblFilters;
    private JList listFilters;
    private JPanel pnlCateogories;
    private JScrollPane scrollFilters;
    private JTextField txtFilterName;

    public FilterEditor(FilterRepository filters) {
        this.initComponents();
        this.filterRepository = filters;
        if (this.filterRepository.size() == 0) {
            this.filterRepository.add(this.filterRepository.createNewFilter());
        }
        this.filterModel = new FilterModel(this.filterRepository);
        this.init();
    }

    public boolean showWindow() {
        DialogDescriptor dd = new DialogDescriptor((Object)this, NbBundle.getMessage(FilterEditor.class, (String)"LBL_FilterEditor"), true, new Object[]{this.btnOk, this.btnCancel}, (Object)this.btnOk, 0, HelpCtx.DEFAULT_HELP, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
        if (this.btnOk.equals(dd.getValue())) {
            this.updateFilters();
            return true;
        }
        return false;
    }

    private void init() {
        this.initComponents();
        this.listFilters.setModel(this.filterModel);
        this.listFilters.setSelectionModel(this.filterModel.selection);
        this.listFilters.setSelectionMode(0);
        NotificationFilter selected = this.filterRepository.getActive();
        if (null != selected) {
            int selIndex = this.filterModel.getIndexOf(selected);
            this.listFilters.setSelectedIndex(selIndex);
        }
        if (this.filterModel.getSelectedIndex() == -1 && this.filterModel.getSize() > 0) {
            this.listFilters.setSelectedIndex(0);
        }
        this.txtFilterName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            private void update(DocumentEvent e) {
                try {
                    FilterEditor.this.filterModel.setCurrentFilterName(e.getDocument().getText(0, e.getDocument().getLength()));
                    FilterEditor.this.propertyChange(null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.listFilters.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FilterEditor.this.showFilter(FilterEditor.this.filterModel.getSelectedFilter());
                    FilterEditor.this.btnRemoveFilter.setEnabled(FilterEditor.this.filterModel.getSelectedIndex() != -1);
                    FilterEditor.this.txtFilterName.setEnabled(FilterEditor.this.filterModel.getSelectedIndex() != -1);
                }
            }
        });
        this.showFilter(this.filterModel.getSelectedFilter());
        this.btnRemoveFilter.setEnabled(this.filterModel.getSelectedIndex() != -1);
        this.btnOk = new JButton(NbBundle.getMessage(FilterEditor.class, (String)"btnOk"));
        this.btnCancel = new JButton(NbBundle.getMessage(FilterEditor.class, (String)"btnCancel"));
    }

    private void showFilter(NotificationFilter filter) {
        if (null == filter) {
            this.txtFilterName.setText(null);
            this.pnlCateogories.removeAll();
            this.pnlCateogories.add((Component)new CateogoriesPanel(null), "Center");
        } else {
            CategoryFilter categoryFilter = filter.getCategoryFilter();
            CateogoriesPanel cPanel = this.filter2types.get(categoryFilter);
            if (cPanel == null) {
                cPanel = new CateogoriesPanel(categoryFilter == null ? new CategoryFilter() : categoryFilter);
                this.filter2types.put(categoryFilter, cPanel);
                cPanel.addPropertyChangeListener(PROP_VALUE_VALID, this);
            }
            this.pnlCateogories.removeAll();
            this.pnlCateogories.add((Component)cPanel, "Center");
            cPanel.setVisible(true);
            if (this.filterModel.getSelectedFilter() != filter) {
                this.listFilters.setSelectedIndex(this.filterModel.getIndexOf(filter));
            }
            this.txtFilterName.setText(filter.getName());
        }
        this.pnlCateogories.validate();
        this.pnlCateogories.repaint();
    }

    public boolean isValueValid() {
        for (CateogoriesPanel cp : this.filter2types.values()) {
            if (cp.isValueValid()) continue;
            return false;
        }
        return this.txtFilterName.getText().length() != 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (null != this.btnOk) {
            this.btnOk.setEnabled(this.isValueValid());
        }
    }

    void updateFilters() {
        this.filterRepository.clear();
        Iterator filterIt = this.filterModel.iterator();
        while (filterIt.hasNext()) {
            NotificationFilter f = (NotificationFilter)filterIt.next();
            if (this.filter2types.get(f.getCategoryFilter()) != null) {
                f.setCategoryFilter(this.filter2types.get(f.getCategoryFilter()).getFilter());
            }
            this.filterRepository.add(f);
        }
        if (this.filterModel.getSelectedFilter() != null) {
            this.filterRepository.setActive(this.filterModel.getSelectedFilter());
        }
    }

    private void initComponents() {
        this.lblFilters = new JLabel();
        this.scrollFilters = new JScrollPane();
        this.listFilters = new JList();
        this.btnNewFilter = new JButton();
        this.btnRemoveFilter = new JButton();
        this.lblFilterName = new JLabel();
        this.txtFilterName = new JTextField();
        this.pnlCateogories = new JPanel();
        this.lblFilters.setLabelFor(this.listFilters);
        Mnemonics.setLocalizedText((JLabel)this.lblFilters, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.lblFilters.text"));
        this.listFilters.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.listFilters.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.listFilters.toolTipText"));
        this.scrollFilters.setViewportView(this.listFilters);
        Mnemonics.setLocalizedText((AbstractButton)this.btnNewFilter, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnNewFilter.text"));
        this.btnNewFilter.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnNewFilter.toolTipText"));
        this.btnNewFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.onNewFilter(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveFilter, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnRemoveFilter.text"));
        this.btnRemoveFilter.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnRemoveFilter.toolTipText"));
        this.btnRemoveFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterEditor.this.onRemoveFilter(evt);
            }
        });
        this.lblFilterName.setLabelFor(this.txtFilterName);
        Mnemonics.setLocalizedText((JLabel)this.lblFilterName, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.lblFilterName.text"));
        this.txtFilterName.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.txtFilterName.toolTipText"));
        this.pnlCateogories.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblFilters).addGroup(layout.createSequentialGroup().addComponent(this.btnNewFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemoveFilter)).addComponent(this.scrollFilters)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblFilterName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtFilterName, -1, 481, Short.MAX_VALUE)).addComponent(this.pnlCateogories, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblFilters).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrollFilters, -1, 232, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNewFilter).addComponent(this.btnRemoveFilter))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFilterName).addComponent(this.txtFilterName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlCateogories, -1, -1, Short.MAX_VALUE))).addContainerGap()));
    }

    private void onRemoveFilter(ActionEvent evt) {
        int i = this.filterModel.getSelectedIndex();
        if (i != -1) {
            NotificationFilter f = this.filterModel.get(i);
            this.filterModel.remove(i);
            this.filter2types.remove(f.getCategoryFilter());
        }
    }

    private void onNewFilter(ActionEvent evt) {
        NotificationFilter f = this.filterRepository.createNewFilter();
        this.filterModel.add(f);
        this.showFilter(f);
    }

    private static class FilterModel
    extends AbstractListModel {
        public DefaultListSelectionModel selection = new DefaultListSelectionModel();
        public ArrayList<NotificationFilter> filters;

        public FilterModel(FilterRepository rep) {
            this.filters = new ArrayList(rep.size() * 2);
            int selectedi = 0;
            for (NotificationFilter f : rep.getFilters()) {
                if (f == rep.getActive()) {
                    this.selection.setSelectionInterval(selectedi, selectedi);
                }
                this.filters.add((NotificationFilter)f.clone());
                ++selectedi;
            }
        }

        public Iterator iterator() {
            return this.filters.iterator();
        }

        @Override
        public Object getElementAt(int index) {
            return this.filters.get(index).getName();
        }

        @Override
        public int getSize() {
            return this.filters.size();
        }

        public NotificationFilter getSelectedFilter() {
            if (this.getSelectedIndex() > -1) {
                return this.filters.get(this.getSelectedIndex());
            }
            return null;
        }

        public int getSelectedIndex() {
            int i2;
            int i1 = this.selection.getMinSelectionIndex();
            if (i1 == (i2 = this.selection.getMaxSelectionIndex()) && i1 >= 0 && i1 < this.filters.size()) {
                return i1;
            }
            return -1;
        }

        public void remove(int i) {
            int s = this.getSelectedIndex();
            if (s != -1) {
                this.filters.remove(i);
                this.fireIntervalRemoved(this, i, i);
                if (i < s) {
                    this.selection.setSelectionInterval(s - 1, s - 1);
                }
                if (i == s) {
                    this.selection.setSelectionInterval(100, 0);
                }
            }
        }

        public NotificationFilter get(int i) {
            return this.filters.get(i);
        }

        public boolean add(NotificationFilter f) {
            if (this.filters.add(f)) {
                this.fireIntervalAdded(this, this.filters.size() - 1, this.filters.size() - 1);
                return true;
            }
            return false;
        }

        public int getIndexOf(NotificationFilter f) {
            return this.filters.indexOf(f);
        }

        public void setCurrentFilterName(String name) {
            int selIndex = this.getSelectedIndex();
            if (selIndex >= 0) {
                this.get(selIndex).setName(name);
                this.fireContentsChanged(this, selIndex, selIndex);
            }
        }
    }
}

