/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractAction;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.websvc.api.support.AddOperationCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.AddWsOperationHelper;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddOperationAction
extends AbstractAction
implements AddOperationCookie {
    private ProjectService service;
    private DataObject dataObject;

    public AddOperationAction(ProjectService service, FileObject implementationClass) {
        super(AddOperationAction.getName());
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/websvc/design/view/resources/operation.png", (boolean)false));
        this.putValue("ShortDescription", NbBundle.getMessage(AddOperationAction.class, (String)"Hint_AddOperation"));
        this.putValue("MnemonicKey", Integer.valueOf(NbBundle.getMessage(AddOperationAction.class, (String)"LBL_AddOperation_mnem_pos")));
        this.service = service;
        try {
            this.dataObject = DataObject.find((FileObject)implementationClass);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public static String getMainClassName(FileObject classFO) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)classFO);
        final String[] result = new String[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement classEl = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                if (classEl != null) {
                    result[0] = classEl.getQualifiedName().toString();
                }
            }
        }, true);
        return result[0];
    }

    private static String getName() {
        return NbBundle.getMessage(AddOperationAction.class, (String)"LBL_AddOperation");
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            this.addJavaMethod();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void saveImplementationClass() throws IOException {
        SaveCookie cookie;
        if (this.dataObject.isModified() && (cookie = (SaveCookie)this.dataObject.getCookie(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    private void addJavaMethod() throws IOException {
        AddWsOperationHelper strategy = new AddWsOperationHelper(AddOperationAction.getName());
        String className = AddOperationAction.getMainClassName(this.dataObject.getPrimaryFile());
        if (className != null) {
            strategy.addMethod(this.dataObject.getPrimaryFile(), className);
            this.saveImplementationClass();
        }
    }

    public void addOperation() {
        this.actionPerformed(null);
    }

    public boolean isEnabledInEditor(Lookup nodeLookup) {
        return this.service != null && this.service.getWsdlUrl() == null;
    }
}

