/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.web.jsf.palette.items.CancellableDialog;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JsfTemplateUtils {
    public static final String BASE_TPL_PATH = "/Templates/JSF/JSF_From_Entity_Wizard";
    public static final String STANDARD_TPL = "StandardJSF";
    private static final String LOCALIZING_BUNDLE = "SystemFileSystem.localizingBundle";
    private static final Comparator TEMPLATE_COMPARATOR = new TemplateComparator();

    public static String getLocalizedName(FileObject fo) {
        String name = fo.getNameExt();
        String bundleName = (String)fo.getAttribute(LOCALIZING_BUNDLE);
        if (bundleName != null) {
            try {
                bundleName = Utilities.translate((String)bundleName);
                ResourceBundle b = NbBundle.getBundle((String)bundleName);
                String localizedName = b.getString(fo.getPath());
                if (localizedName != null) {
                    name = localizedName;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return name;
    }

    public static List<Template> getTemplates(TemplateType tt) {
        ArrayList<Template> result = new ArrayList<Template>();
        FileObject templateRoot = FileUtil.getConfigRoot().getFileObject(tt.getValue());
        assert (templateRoot != null);
        Enumeration children = templateRoot.getChildren(false);
        while (children.hasMoreElements()) {
            FileObject folder = (FileObject)children.nextElement();
            Object position = folder.getAttribute("position");
            if (!(position instanceof Integer)) {
                result.add(new Template(folder.getName(), JsfTemplateUtils.getLocalizedName(folder)));
                continue;
            }
            result.add(new Template(folder.getName(), JsfTemplateUtils.getLocalizedName(folder), (Integer)position));
        }
        result.sort(TEMPLATE_COMPARATOR);
        return result;
    }

    public static String getTemplatePath(TemplateType tt, String templatesStyle, String template) {
        return tt.getValue() + "/" + templatesStyle + "/" + template;
    }

    public static enum TemplateType {
        SNIPPETS("/Templates/JSF/JSF_From_Entity_Snippets"),
        PAGES("/Templates/JSF/JSF_From_Entity_Wizard");

        private final String value;

        private TemplateType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Template {
        private final String name;
        private final String displayName;
        private final int position;

        public Template(String name, String displayName) {
            this(name, displayName, Integer.MAX_VALUE);
        }

        public Template(String name, String displayName, int position) {
            this.name = name;
            this.displayName = displayName;
            this.position = position;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public static class TemplateComparator
    implements Comparator<Template> {
        @Override
        public int compare(Template o1, Template o2) {
            return o1.getPosition() - o2.getPosition();
        }
    }

    public static class OpenTemplateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String[] templateFileName;
        private CancellableDialog panel;

        public OpenTemplateAction(CancellableDialog panel, String actionName, String ... templateFileName) {
            this.templateFileName = templateFileName;
            this.panel = panel;
            this.putValue("Name", actionName);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (String template : this.templateFileName) {
                this.openSingle(template);
            }
        }

        private void openSingle(String template) {
            FileObject tableTemplate = FileUtil.getConfigRoot().getFileObject(template);
            try {
                final DataObject dob = DataObject.find((FileObject)tableTemplate);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((EditCookie)dob.getLookup().lookup(EditCookie.class)).edit();
                    }
                });
                this.panel.cancel();
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static class TemplateCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Template) {
                renderer.setText(((Template)value).getDisplayName());
            }
            return renderer;
        }
    }
}

