/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.servlet.http.Part;
import org.primefaces.model.UploadedFile;

public class NativeUploadedFile
implements UploadedFile,
Serializable {
    private Part part;
    private String filename;

    public NativeUploadedFile() {
    }

    public NativeUploadedFile(Part part) {
        this.part = part;
        this.filename = this.resolveFilename(part);
    }

    public String getFileName() {
        return this.filename;
    }

    public InputStream getInputstream() throws IOException {
        return this.part.getInputStream();
    }

    public long getSize() {
        return this.part.getSize();
    }

    public byte[] getContents() {
        return null;
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    private String resolveFilename(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }
}

