/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.processor;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor6;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedAnnotationTypes(value={"org.netbeans.spi.java.hints.*"})
public class JavaHintsAnnotationProcessor
extends LayerGeneratingProcessor {
    private static final String[] TRIGGERS = new String[]{"org.netbeans.spi.java.hints.TriggerTreeKind", "org.netbeans.spi.java.hints.TriggerPattern", "org.netbeans.spi.java.hints.TriggerPatterns"};
    private static final String[] OPTIONS = new String[]{"org.netbeans.spi.java.hints.BooleanOption"};
    static final String ERR_RETURN_TYPE = "The return type must be either org.netbeans.spi.editor.hints.ErrorDescription or java.util.List<org.netbeans.spi.editor.hints.ErrorDescription>";
    static final String ERR_PARAMETERS = "The method must have exactly one parameter of type org.netbeans.spi.java.hints.HintContext";
    static final String ERR_MUST_BE_STATIC = "The method must be static";
    static final String ERR_OPTION_TYPE = "The option field must be of type java.lang.String";
    static final String ERR_OPTION_MUST_BE_STATIC_FINAL = "The option field must be static final";
    static final String WARN_BUNDLE_KEY_NOT_FOUND = "Bundle key %s not found";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$[a-zA-Z0-9_]+");

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        if (!roundEnv.processingOver()) {
            this.generateTypeList("org.netbeans.spi.java.hints.Hint", roundEnv);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void generateTypeList(String annotationName, RoundEnvironment roundEnv) throws LayerGenerationException {
        TypeElement annRes;
        TypeElement hint = this.processingEnv.getElementUtils().getTypeElement(annotationName);
        if (hint == null) {
            return;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(hint)) {
            LayerBuilder builder;
            void var5_5;
            if (!this.verifyHintAnnotationAcceptable(element)) continue;
            if (!element.getKind().isClass() && !element.getKind().isInterface()) {
                if (element.getKind() != ElementKind.METHOD) continue;
                Element element2 = element.getEnclosingElement();
            } else if (!element.getKind().isClass()) continue;
            if (!var5_5.getKind().isClass()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error - cannot find class containing the hint", (Element)var5_5);
                continue;
            }
            TypeElement clazz = (TypeElement)var5_5;
            String classFolder = "org-netbeans-modules-java-hints/code-hints/" + this.getFQN(clazz).replace('.', '-') + ".class";
            LayerBuilder builder2 = this.layer(new Element[]{clazz});
            LayerBuilder.File clazzFolder = builder2.folder(classFolder);
            for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
                this.dumpAnnotation(builder2, clazzFolder, clazz, annotationMirror, true);
            }
            clazzFolder.write();
            for (ExecutableElement ee : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                if (ee.getAnnotationMirrors().isEmpty()) continue;
                builder = this.layer(new Element[]{ee});
                LayerBuilder.File file = builder.folder(classFolder + "/" + ee.getSimpleName() + ".method");
                for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
                    this.dumpAnnotation(builder, file, ee, annotationMirror, true);
                }
                file.write();
            }
            for (VariableElement var : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
                if (var.getAnnotationMirrors().isEmpty()) continue;
                builder = this.layer(new Element[]{var});
                LayerBuilder.File file = builder.folder(classFolder + "/" + var.getSimpleName() + ".field");
                for (AnnotationMirror annotationMirror : var.getAnnotationMirrors()) {
                    this.dumpAnnotation(builder, file, var, annotationMirror, true);
                }
                Object object = var.getConstantValue();
                if (object instanceof String) {
                    String value = (String)object;
                    file.stringvalue("constantValue", value);
                }
                file.write();
            }
            new ElementScanner6<Void, Void>(){

                @Override
                public Void scan(Element e, Void p) {
                    AnnotationMirror hintMirror = JavaHintsAnnotationProcessor.findAnnotation(e.getAnnotationMirrors(), "org.netbeans.spi.java.hints.Hint");
                    if (hintMirror != null) {
                        String qualifiedName = switch (e.getKind()) {
                            case ElementKind.METHOD, ElementKind.CONSTRUCTOR -> e.getEnclosingElement().asType().toString() + "." + e.getSimpleName().toString() + e.asType().toString();
                            case ElementKind.FIELD, ElementKind.ENUM_CONSTANT -> e.getEnclosingElement().asType().toString() + "." + e.getSimpleName().toString();
                            default -> e.asType().toString();
                        };
                        try {
                            String description;
                            LayerBuilder.File keywordsFile = JavaHintsAnnotationProcessor.this.layer(new Element[]{e}).file("OptionsDialog/Keywords/".concat(qualifiedName)).stringvalue("location", "Editor").bundlevalue("tabTitle", "org.netbeans.modules.options.editor.Bundle", "CTL_Hints_DisplayName");
                            String displayName = JavaHintsAnnotationProcessor.this.getAttributeValue(hintMirror, "displayName", String.class);
                            if (displayName != null) {
                                keywordsFile = keywordsFile.bundlevalue("keywords-1", displayName);
                            }
                            if ((description = JavaHintsAnnotationProcessor.this.getAttributeValue(hintMirror, "description", String.class)) != null) {
                                keywordsFile = keywordsFile.bundlevalue("keywords-2", description);
                            }
                            int i = 3;
                            for (String sw : JavaHintsAnnotationProcessor.this.getAttributeValue(hintMirror, "suppressWarnings", String[].class)) {
                                keywordsFile = keywordsFile.stringvalue("keywords-" + i++, sw);
                            }
                            keywordsFile.write();
                        }
                        catch (LayerGenerationException ex) {
                            JavaHintsAnnotationProcessor.rethrowAsRuntime(ex);
                        }
                    }
                    return (Void)super.scan(e, p);
                }
            }.scan((Element)var5_5, null);
        }
        for (String ann : TRIGGERS) {
            annRes = this.processingEnv.getElementUtils().getTypeElement(ann);
            if (annRes == null) continue;
            for (ExecutableElement method : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(annRes))) {
                this.verifyHintMethod(method);
                this.verifyTriggerAnnotations(method);
            }
        }
        for (String ann : OPTIONS) {
            annRes = this.processingEnv.getElementUtils().getTypeElement(ann);
            if (annRes == null) continue;
            for (VariableElement var : ElementFilter.fieldsIn(roundEnv.getElementsAnnotatedWith(annRes))) {
                this.verifyOptionField(var);
            }
        }
    }

    private void dumpAnnotation(LayerBuilder builder, LayerBuilder.File folder, Element errElement, AnnotationMirror annotation, boolean topLevel) {
        String fqn = this.getFQN((TypeElement)annotation.getAnnotationType().asElement()).replace('.', '-');
        if (topLevel && !fqn.startsWith("org-netbeans-spi-java-hints")) {
            return;
        }
        LayerBuilder.File annotationFolder = builder.folder(folder.getPath() + "/" + fqn + ".annotation");
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotation.getElementValues().entrySet()) {
            String attrName = e.getKey().getSimpleName().toString();
            e.getValue().accept(new DumpAnnotationValue(builder, annotationFolder, attrName, errElement, annotation, e.getValue()), null);
        }
        annotationFolder.write();
    }

    private String getFQN(TypeElement clazz) {
        return this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
    }

    private static AnnotationMirror findAnnotation(Iterable<? extends AnnotationMirror> annotations, String annotationFQN) {
        for (AnnotationMirror annotationMirror : annotations) {
            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotationFQN)) continue;
            return annotationMirror;
        }
        return null;
    }

    private <T> T getAttributeValue(AnnotationMirror annotation, String attribute, Class<T> clazz) {
        if (clazz.isArray()) {
            Iterable attributes = this.getAttributeValueInternal(annotation, attribute, Iterable.class);
            ArrayList coll = new ArrayList();
            Class<?> componentType = clazz.getComponentType();
            for (Object attr : attributes) {
                if (attr instanceof AnnotationValue) {
                    AnnotationValue annotationValue = (AnnotationValue)attr;
                    attr = annotationValue.getValue();
                }
                if (!componentType.isAssignableFrom(attr.getClass())) continue;
                coll.add(componentType.cast(attr));
            }
            return clazz.cast(coll.toArray((Object[])Array.newInstance(clazz.getComponentType(), 0)));
        }
        return this.getAttributeValueInternal(annotation, attribute, clazz);
    }

    private <T> T getAttributeValueInternal(AnnotationMirror annotation, String attribute, Class<T> clazz) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotation).entrySet()) {
            if (!e.getKey().getSimpleName().contentEquals(attribute)) continue;
            Object value = e.getValue().getValue();
            if (clazz.isAssignableFrom(value.getClass())) {
                return clazz.cast(value);
            }
            return null;
        }
        return null;
    }

    private AnnotationValue getAttributeValueDescription(AnnotationMirror annotation, String attribute) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotation).entrySet()) {
            if (!e.getKey().getSimpleName().contentEquals(attribute)) continue;
            return e.getValue();
        }
        return null;
    }

    private boolean verifyHintAnnotationAcceptable(Element hint) {
        Element customizerProvider;
        TypeMirror customizerProviderType;
        AnnotationMirror hintMirror = JavaHintsAnnotationProcessor.findAnnotation(hint.getAnnotationMirrors(), "org.netbeans.spi.java.hints.Hint");
        if (hintMirror == null) {
            return false;
        }
        String id = this.getAttributeValue(hintMirror, "id", String.class);
        if (id == null || id.isEmpty()) {
            switch (hint.getKind()) {
                case METHOD: 
                case CLASS: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if ((customizerProviderType = this.getAttributeValue(hintMirror, "customizerProvider", TypeMirror.class)) != null && (customizerProvider = this.processingEnv.getTypeUtils().asElement(customizerProviderType)) != null) {
            if (customizerProvider.getKind() != ElementKind.CLASS) {
                TypeElement customizerProviderInterface = this.processingEnv.getElementUtils().getTypeElement("org.netbeans.spi.java.hints.CustomizerProvider");
                if (customizerProviderInterface != null && !customizerProviderInterface.equals(customizerProvider)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Customizer provider must be a concrete class", hint, hintMirror, this.getAttributeValueDescription(hintMirror, "customizerProvider"));
                }
            } else {
                TypeElement customizerProviderClazz = (TypeElement)customizerProvider;
                if (!customizerProviderClazz.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Customizer provider must be public", hint, hintMirror, this.getAttributeValueDescription(hintMirror, "customizerProvider"));
                }
                if (customizerProviderClazz.getEnclosingElement().getKind() != ElementKind.PACKAGE && !customizerProviderClazz.getModifiers().contains((Object)Modifier.STATIC)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Customizer provider must be non-static innerclass", hint, hintMirror, this.getAttributeValueDescription(hintMirror, "customizerProvider"));
                }
                boolean foundDefaultConstructor = false;
                for (ExecutableElement ee : ElementFilter.constructorsIn(customizerProviderClazz.getEnclosedElements())) {
                    if (!ee.getParameters().isEmpty()) continue;
                    foundDefaultConstructor = true;
                    if (ee.getModifiers().contains((Object)Modifier.PUBLIC)) break;
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Customizer provider must provide a public default constructor", hint, hintMirror, this.getAttributeValueDescription(hintMirror, "customizerProvider"));
                    break;
                }
                if (!foundDefaultConstructor) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Customizer provider must provide a public default constructor", hint, hintMirror, this.getAttributeValueDescription(hintMirror, "customizerProvider"));
                }
            }
        }
        return true;
    }

    private boolean verifyHintMethod(ExecutableElement method) {
        StringBuilder error = new StringBuilder();
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement errDesc = elements.getTypeElement("org.netbeans.spi.editor.hints.ErrorDescription");
        TypeElement jlIterable = elements.getTypeElement("java.lang.Iterable");
        TypeElement hintCtx = elements.getTypeElement("org.netbeans.spi.java.hints.HintContext");
        if (errDesc == null || jlIterable == null || hintCtx == null) {
            return true;
        }
        Types types = this.processingEnv.getTypeUtils();
        TypeMirror errDescType = errDesc.asType();
        DeclaredType jlIterableErrDesc = types.getDeclaredType(jlIterable, errDescType);
        TypeMirror ret = method.getReturnType();
        if (!types.isSameType(ret, errDescType) && !types.isAssignable(ret, jlIterableErrDesc)) {
            error.append(ERR_RETURN_TYPE);
            error.append("\n");
        }
        if (method.getParameters().size() != 1 || !types.isSameType(method.getParameters().get(0).asType(), hintCtx.asType())) {
            error.append(ERR_PARAMETERS);
            error.append("\n");
        }
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            error.append(ERR_MUST_BE_STATIC);
            error.append("\n");
        }
        if (error.length() == 0) {
            return true;
        }
        if (error.charAt(error.length() - 1) == '\n') {
            error.delete(error.length() - 1, error.length());
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error.toString(), method);
        return false;
    }

    private boolean verifyTriggerAnnotations(ExecutableElement method) {
        ArrayList<AnnotationMirror> patternAnnotations = new ArrayList<AnnotationMirror>();
        AnnotationMirror am = JavaHintsAnnotationProcessor.findAnnotation(method.getAnnotationMirrors(), "org.netbeans.spi.java.hints.TriggerPattern");
        if (am != null) {
            patternAnnotations.add(am);
        }
        if ((am = JavaHintsAnnotationProcessor.findAnnotation(method.getAnnotationMirrors(), "org.netbeans.spi.java.hints.TriggerPatterns")) != null) {
            patternAnnotations.addAll(Arrays.asList(this.getAttributeValue(am, "value", AnnotationMirror[].class)));
        }
        for (AnnotationMirror patternDescription : patternAnnotations) {
            String pattern = this.getAttributeValue(patternDescription, "value", String.class);
            if (pattern == null) continue;
            HashSet<String> variables = new HashSet<String>();
            Matcher m = VARIABLE_PATTERN.matcher(pattern);
            while (m.find()) {
                variables.add(m.group(0));
            }
            for (AnnotationMirror constraint : this.getAttributeValue(patternDescription, "constraints", AnnotationMirror[].class)) {
                String variable = this.getAttributeValue(constraint, "variable", String.class);
                String type = this.getAttributeValue(constraint, "type", String.class);
                if (variable == null || type == null || variables.contains(variable)) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Variable " + variable + " not used in the pattern", method, constraint, this.getAttributeValueDescription(constraint, "variable"));
            }
        }
        return false;
    }

    private boolean verifyOptionField(VariableElement field) {
        Object key;
        StringBuilder error = new StringBuilder();
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement jlString = elements.getTypeElement("java.lang.String");
        if (jlString == null) {
            return true;
        }
        Types types = this.processingEnv.getTypeUtils();
        TypeMirror jlStringType = jlString.asType();
        if (!types.isSameType(field.asType(), jlStringType)) {
            error.append(ERR_RETURN_TYPE);
            error.append("\n");
        }
        if (!field.getModifiers().contains((Object)Modifier.STATIC) || !field.getModifiers().contains((Object)Modifier.FINAL)) {
            error.append(ERR_OPTION_MUST_BE_STATIC_FINAL);
            error.append("\n");
        }
        if ((key = field.getConstantValue()) == null) {
            error.append("Option field not a compile-time constant");
            error.append("\n");
        }
        if (error.length() == 0) {
            return true;
        }
        if (error.charAt(error.length() - 1) == '\n') {
            error.delete(error.length() - 1, error.length());
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error.toString(), field);
        return false;
    }

    private static <T extends Throwable> void rethrowAsRuntime(Throwable t) throws T {
        throw t;
    }

    private class DumpAnnotationValue
    extends AbstractAnnotationValueVisitor6<Void, Void> {
        private final LayerBuilder builder;
        private final LayerBuilder.File annotationFolder;
        private final String attrName;
        private final Element errElement;
        private final AnnotationMirror errAnnotationMirror;
        private final AnnotationValue errAnnotationValue;

        public DumpAnnotationValue(LayerBuilder builder, LayerBuilder.File annotationFolder, String attrName, Element errElement, AnnotationMirror errAnnotationMirror, AnnotationValue errAnnotationValue) {
            this.builder = builder;
            this.annotationFolder = annotationFolder;
            this.attrName = attrName;
            this.errElement = errElement;
            this.errAnnotationMirror = errAnnotationMirror;
            this.errAnnotationValue = errAnnotationValue;
        }

        @Override
        public Void visitBoolean(boolean b, Void p) {
            this.annotationFolder.boolvalue(this.attrName, b);
            return null;
        }

        @Override
        public Void visitByte(byte b, Void p) {
            this.annotationFolder.bytevalue(this.attrName, b);
            return null;
        }

        @Override
        public Void visitChar(char c, Void p) {
            this.annotationFolder.charvalue(this.attrName, c);
            return null;
        }

        @Override
        public Void visitDouble(double d, Void p) {
            this.annotationFolder.doublevalue(this.attrName, d);
            return null;
        }

        @Override
        public Void visitFloat(float f, Void p) {
            this.annotationFolder.floatvalue(this.attrName, f);
            return null;
        }

        @Override
        public Void visitInt(int i, Void p) {
            this.annotationFolder.intvalue(this.attrName, i);
            return null;
        }

        @Override
        public Void visitLong(long i, Void p) {
            this.annotationFolder.longvalue(this.attrName, i);
            return null;
        }

        @Override
        public Void visitShort(short s, Void p) {
            this.annotationFolder.shortvalue(this.attrName, s);
            return null;
        }

        @Override
        public Void visitString(String s, Void p) {
            if ("displayName".equals(this.attrName) || "description".equals(this.attrName) || "tooltip".equals(this.attrName)) {
                try {
                    this.annotationFolder.bundlevalue(this.attrName, s);
                }
                catch (LayerGenerationException ex) {
                    JavaHintsAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getLocalizedMessage(), this.errElement, this.errAnnotationMirror, this.errAnnotationValue);
                }
            } else {
                this.annotationFolder.stringvalue(this.attrName, s);
            }
            return null;
        }

        @Override
        public Void visitType(TypeMirror t, Void p) {
            this.annotationFolder.stringvalue(this.attrName, JavaHintsAnnotationProcessor.this.getFQN((TypeElement)((DeclaredType)t).asElement()));
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c, Void p) {
            TypeElement owner = (TypeElement)c.getEnclosingElement();
            this.annotationFolder.stringvalue(this.attrName, JavaHintsAnnotationProcessor.this.getFQN(owner) + "." + c.getSimpleName());
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, Void p) {
            LayerBuilder.File f = this.builder.folder(this.annotationFolder.getPath() + "/" + this.attrName);
            JavaHintsAnnotationProcessor.this.dumpAnnotation(this.builder, f, this.errElement, a, false);
            f.write();
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
            LayerBuilder.File arr = this.builder.folder(this.annotationFolder.getPath() + "/" + this.attrName);
            int c = 0;
            for (AnnotationValue annotationValue : vals) {
                annotationValue.accept(new DumpAnnotationValue(this.builder, arr, "item" + c, this.errElement, this.errAnnotationMirror, annotationValue), null);
                ++c;
            }
            arr.write();
            return null;
        }
    }
}

