/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.symbol;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.event.ChangeListener;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.WeakListeners;

public final class MicronautSymbolFinder
extends EmbeddingIndexer
implements PropertyChangeListener {
    public static final String NAME = "mn";
    public static final int VERSION = 1;
    private static final MicronautSymbolFinder INSTANCE = new MicronautSymbolFinder();
    private static final String[] META_ANNOTATIONS = new String[]{"io.micronaut.http.annotation.HttpMethodMapping", "io.micronaut.context.annotation.Bean", "jakarta.inject.Qualifier", "jakarta.inject.Scope"};
    private static final String CONTROLLER_ANNOTATION = "io.micronaut.http.annotation.Controller";
    private static final String HTTP_METHOD_MAPPING_ANNOTATION = "io.micronaut.http.annotation.HttpMethodMapping";
    private static final String MANAGEMENT_ENDPOINT_ANNOTATION = "io.micronaut.management.endpoint.annotation.Endpoint";
    private static final String MANAGEMENT_READ_ANNOTATION = "io.micronaut.management.endpoint.annotation.Read";
    private static final String MANAGEMENT_WRITE_ANNOTATION = "io.micronaut.management.endpoint.annotation.Write";
    private static final String MANAGEMENT_DELETE_ANNOTATION = "io.micronaut.management.endpoint.annotation.Delete";
    private static final String MANAGEMENT_SELECTOR_ANNOTATION = "io.micronaut.management.endpoint.annotation.Selector";
    private static final String AWS_FUNCTION = "io.micronaut.function.aws.MicronautRequestHandler";
    private static final String OCI_FUNCTION = "io.micronaut.oraclecloud.function.OciFunction";
    private final Map<FileObject, Boolean> map = new WeakHashMap<FileObject, Boolean>();
    private final Map<ClasspathInfo, List<ClassSymbolLocation>> cache = new WeakHashMap<ClasspathInfo, List<ClassSymbolLocation>>();
    private final ChangeListener cacheCleaner = evt -> {
        if (this.cache.keySet().contains(evt.getSource())) {
            this.cache.clear();
        }
    };

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        CompilationController cc = CompilationController.get((Parser.Result)parserResult);
        if (this.initialize(cc)) {
            try {
                if (cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                    this.store(context.getIndexFolder(), indexable.getURL(), indexable.getRelativePath(), MicronautSymbolFinder.scan(cc, false));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        MicronautSymbolFinder micronautSymbolFinder = this;
        synchronized (micronautSymbolFinder) {
            this.map.clear();
        }
    }

    private synchronized boolean initialize(CompilationController cc) {
        Project p = FileOwnerQuery.getOwner((FileObject)cc.getFileObject());
        if (p == null) {
            return false;
        }
        for (SourceGroup sg : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
            if (!sg.contains(cc.getFileObject())) continue;
            FileObject root = sg.getRootFolder();
            Boolean ret = this.map.get(root);
            if (ret == null) {
                ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
                cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)cp));
                ret = MicronautSymbolFinder.resolveClassName(cp, HTTP_METHOD_MAPPING_ANNOTATION, MANAGEMENT_ENDPOINT_ANNOTATION, AWS_FUNCTION, OCI_FUNCTION);
                this.map.put(root, ret);
            }
            return ret;
        }
        return false;
    }

    private static boolean resolveClassName(ClassPath cp, String ... fqns) {
        for (String fqn : fqns) {
            if (cp.findResource(fqn.replace('.', '/') + ".class") == null) continue;
            return true;
        }
        return false;
    }

    public static List<SymbolLocation> scan(final CompilationController cc, final boolean selectEndpointAnnotation) {
        final ArrayList<SymbolLocation> ret = new ArrayList<SymbolLocation>();
        final SourcePositions sp = cc.getTrees().getSourcePositions();
        TreePathScanner<Void, String> scanner = new TreePathScanner<Void, String>(){
            private String functionName = null;

            @Override
            public Void visitClass(ClassTree node, String path) {
                TreePath treePath = this.getCurrentPath();
                Element cls = cc.getTrees().getElement(treePath);
                if (cls != null) {
                    TypeElement awsFunctionTE;
                    Pair metaAnnotated = MicronautSymbolFinder.isMetaAnnotated(cls);
                    if (metaAnnotated != null) {
                        path = MicronautSymbolFinder.getPath((AnnotationMirror)metaAnnotated.first());
                        Element annEl = ((AnnotationMirror)metaAnnotated.first()).getAnnotationType().asElement();
                        String name = "@+ '" + MicronautSymbolFinder.getBeanName(node.getSimpleName().toString()) + "' (@" + annEl.getSimpleName() + (metaAnnotated.second() != null ? " <: @" + ((AnnotationMirror)metaAnnotated.second()).getAnnotationType().asElement().getSimpleName() : "") + ") " + node.getSimpleName();
                        int[] span = cc.getTreeUtilities().findNameSpan(node);
                        ret.add(new SymbolLocation(name, (int)sp.getStartPosition(treePath.getCompilationUnit(), node), (int)sp.getEndPosition(treePath.getCompilationUnit(), node), span[0], span[1]));
                    } else {
                        path = MicronautSymbolFinder.getPath((TypeElement)cls);
                    }
                    TypeElement ociFunctionTE = cc.getElements().getTypeElement(MicronautSymbolFinder.OCI_FUNCTION);
                    if (ociFunctionTE != null && cc.getTypes().isSubtype(cc.getTypes().erasure(cls.asType()), ociFunctionTE.asType())) {
                        this.functionName = Utils.getOciFunctionName((CompilationInfo)cc, ((TypeElement)cls).getQualifiedName().toString());
                    }
                    if ((awsFunctionTE = cc.getElements().getTypeElement(MicronautSymbolFinder.AWS_FUNCTION)) != null && cc.getTypes().isSubtype(cc.getTypes().erasure(cls.asType()), awsFunctionTE.asType())) {
                        this.functionName = "handleRequest";
                    }
                }
                return (Void)super.visitClass(node, path);
            }

            @Override
            public Void visitMethod(MethodTree node, String path) {
                TreePath treePath = this.getCurrentPath();
                if (this.functionName != null && this.functionName.contentEquals(node.getName())) {
                    int[] span = cc.getTreeUtilities().findNameSpan(node);
                    ret.add(new SymbolLocation("@/ -- POST", (int)sp.getStartPosition(treePath.getCompilationUnit(), node), (int)sp.getEndPosition(treePath.getCompilationUnit(), node), span[0], span[1]));
                } else if (path != null) {
                    Element mth = cc.getTrees().getElement(treePath);
                    MthIterator it = new MthIterator(mth, cc.getElements(), cc.getTypes());
                    while (it.hasNext()) {
                        ExecutableElement ee = it.next();
                        for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
                            String method = MicronautSymbolFinder.getEndpointMethod((TypeElement)annotationMirror.getAnnotationType().asElement());
                            if (method == null) continue;
                            ArrayList<String> ids = new ArrayList<String>();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                                if ("value".contentEquals(entry.getKey().getSimpleName()) || "uri".contentEquals(entry.getKey().getSimpleName())) {
                                    ids.add((String)entry.getValue().getValue());
                                    continue;
                                }
                                if (!"uris".contentEquals(entry.getKey().getSimpleName())) continue;
                                for (AnnotationValue av : (List)entry.getValue().getValue()) {
                                    ids.add((String)av.getValue());
                                }
                            }
                            if (ids.isEmpty()) {
                                ids.add(MicronautSymbolFinder.getId(ee));
                            }
                            for (Map.Entry<ExecutableElement, AnnotationValue> entry : ids) {
                                Tree tree;
                                String name = '@' + path + entry + " -- " + method;
                                int[] span = cc.getTreeUtilities().findNameSpan(node);
                                if (selectEndpointAnnotation && (tree = cc.getTrees().getTree(ee, annotationMirror)) != null) {
                                    span = new int[]{(int)sp.getStartPosition(treePath.getCompilationUnit(), tree), (int)sp.getEndPosition(treePath.getCompilationUnit(), tree)};
                                }
                                ret.add(new SymbolLocation(name, (int)sp.getStartPosition(treePath.getCompilationUnit(), node), (int)sp.getEndPosition(treePath.getCompilationUnit(), node), span[0], span[1]));
                            }
                            return null;
                        }
                    }
                }
                return null;
            }
        };
        scanner.scan(cc.getCompilationUnit(), null);
        return ret;
    }

    private void store(FileObject indexFolder, URL url, String resourceName, List<SymbolLocation> symbols) {
        File cacheRoot = FileUtil.toFile((FileObject)indexFolder);
        File output = new File(cacheRoot, resourceName + ".mn");
        if (symbols.isEmpty()) {
            if (output.exists()) {
                output.delete();
            }
        } else {
            output.getParentFile().mkdirs();
            try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));){
                pw.print("url: ");
                pw.println(url.toString());
                for (SymbolLocation symbol : symbols) {
                    pw.print("symbol: ");
                    pw.print(symbol.name);
                    pw.print(':');
                    pw.print(symbol.selectionStart);
                    pw.print('-');
                    pw.println(symbol.selectionEnd);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static Pair<AnnotationMirror, AnnotationMirror> isMetaAnnotated(Element el) {
        for (AnnotationMirror annotationMirror : el.getAnnotationMirrors()) {
            Element annEl = annotationMirror.getAnnotationType().asElement();
            Name name = ((TypeElement)annEl).getQualifiedName();
            String annotation = MicronautSymbolFinder.check(name);
            if (annotation != null) {
                return Pair.of((Object)annotationMirror, null);
            }
            for (AnnotationMirror annotationMirror2 : annEl.getAnnotationMirrors()) {
                Element metaAnnEl = annotationMirror2.getAnnotationType().asElement();
                String metaAnnotation = MicronautSymbolFinder.check(((TypeElement)metaAnnEl).getQualifiedName());
                if (metaAnnotation == null) continue;
                return Pair.of((Object)annotationMirror, (Object)annotationMirror2);
            }
        }
        return null;
    }

    private static String check(Name name) {
        for (String ann : META_ANNOTATIONS) {
            if (!ann.contentEquals(name)) continue;
            return ann;
        }
        return null;
    }

    public static String getEndpointMethod(TypeElement te) {
        switch (te.getQualifiedName().toString()) {
            case "io.micronaut.management.endpoint.annotation.Read": {
                return "GET";
            }
            case "io.micronaut.management.endpoint.annotation.Write": {
                return "POST";
            }
            case "io.micronaut.management.endpoint.annotation.Delete": {
                return "DELETE";
            }
        }
        for (AnnotationMirror annotationMirror : te.getAnnotationMirrors()) {
            Element el = annotationMirror.getAnnotationType().asElement();
            if (!HTTP_METHOD_MAPPING_ANNOTATION.contentEquals(((TypeElement)el).getQualifiedName())) continue;
            return te.getSimpleName().toString().toUpperCase();
        }
        return null;
    }

    private static String getBeanName(String typeName) {
        if (typeName.length() > 0 && Character.isUpperCase(typeName.charAt(0)) && (typeName.length() == 1 || !Character.isUpperCase(typeName.charAt(1)))) {
            typeName = Character.toLowerCase(typeName.charAt(0)) + typeName.substring(1);
        }
        return typeName;
    }

    private static String getPath(AnnotationMirror ann) {
        String path = null;
        Element annEl = ann.getAnnotationType().asElement();
        switch (((TypeElement)annEl).getQualifiedName().toString()) {
            case "io.micronaut.http.annotation.Controller": {
                path = "/";
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ann.getElementValues().entrySet()) {
                    if (!"value".contentEquals(entry.getKey().getSimpleName())) continue;
                    path = (String)entry.getValue().getValue();
                }
                break;
            }
            case "io.micronaut.management.endpoint.annotation.Endpoint": {
                path = "/";
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : ann.getElementValues().entrySet()) {
                    if (!"value".contentEquals(entry.getKey().getSimpleName()) && !"id".contentEquals(entry.getKey().getSimpleName())) continue;
                    path = (String)entry.getValue().getValue();
                }
                break;
            }
        }
        if (path != null && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    private static String getPath(TypeElement te) {
        for (AnnotationMirror annotationMirror : te.getAnnotationMirrors()) {
            String path = MicronautSymbolFinder.getPath(annotationMirror);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private static String getId(ExecutableElement ee) {
        StringBuilder sb = new StringBuilder();
        for (VariableElement variableElement : ee.getParameters()) {
            for (AnnotationMirror annotationMirror : variableElement.getAnnotationMirrors()) {
                Element el = annotationMirror.getAnnotationType().asElement();
                if (!MANAGEMENT_SELECTOR_ANNOTATION.contentEquals(((TypeElement)el).getQualifiedName())) continue;
                sb.append("/{").append(variableElement.getSimpleName()).append('}');
            }
        }
        return sb.toString();
    }

    private static String[] getSignatures(Element e) {
        switch (e.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case RECORD: {
                return new String[]{MicronautSymbolFinder.encodeClassNameOrArray((TypeElement)e)};
            }
            case METHOD: {
                return MicronautSymbolFinder.createMethodDescriptor((ExecutableElement)e);
            }
        }
        return new String[0];
    }

    private static String[] createMethodDescriptor(ExecutableElement ee) {
        String[] result = new String[3];
        Element enclosingType = ee.getEnclosingElement();
        if (enclosingType != null && enclosingType.asType().getKind() == TypeKind.NONE) {
            result[0] = "";
        } else {
            assert (enclosingType instanceof TypeElement) : enclosingType == null ? "null" : enclosingType.toString() + "(" + (Object)((Object)enclosingType.getKind()) + ")";
            result[0] = MicronautSymbolFinder.encodeClassNameOrArray((TypeElement)enclosingType);
        }
        StringBuilder retType = new StringBuilder();
        result[1] = ee.getSimpleName().toString();
        if (ee.asType().getKind() == TypeKind.EXECUTABLE) {
            MicronautSymbolFinder.encodeType(ee.getReturnType(), retType);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (VariableElement variableElement : ee.getParameters()) {
            MicronautSymbolFinder.encodeType(variableElement.asType(), sb);
        }
        sb.append(')');
        sb.append((CharSequence)retType);
        result[2] = sb.toString();
        return result;
    }

    private static String encodeClassNameOrArray(TypeElement td) {
        Name qname = td.getQualifiedName();
        TypeMirror enclosingType = td.getEnclosingElement().asType();
        if (qname != null && enclosingType != null && enclosingType.getKind() == TypeKind.NONE && "Array".equals(qname.toString())) {
            return "[";
        }
        return MicronautSymbolFinder.encodeClassName(td);
    }

    private static String encodeClassName(TypeElement td) {
        StringBuilder sb = new StringBuilder();
        MicronautSymbolFinder.encodeClassName(td, sb, '.');
        return sb.toString();
    }

    private static void encodeType(TypeMirror type, StringBuilder sb) {
        switch (type.getKind()) {
            case VOID: {
                sb.append('V');
                break;
            }
            case BOOLEAN: {
                sb.append('Z');
                break;
            }
            case BYTE: {
                sb.append('B');
                break;
            }
            case SHORT: {
                sb.append('S');
                break;
            }
            case INT: {
                sb.append('I');
                break;
            }
            case LONG: {
                sb.append('J');
                break;
            }
            case CHAR: {
                sb.append('C');
                break;
            }
            case FLOAT: {
                sb.append('F');
                break;
            }
            case DOUBLE: {
                sb.append('D');
                break;
            }
            case ARRAY: {
                sb.append('[');
                MicronautSymbolFinder.encodeType(((ArrayType)type).getComponentType(), sb);
                break;
            }
            case DECLARED: {
                sb.append('L');
                TypeElement te = (TypeElement)((DeclaredType)type).asElement();
                MicronautSymbolFinder.encodeClassName(te, sb, '/');
                sb.append(';');
                break;
            }
            case TYPEVAR: {
                TypeVariable tr = (TypeVariable)type;
                TypeMirror upperBound = tr.getUpperBound();
                if (upperBound.getKind() == TypeKind.NULL) {
                    sb.append("Ljava/lang/Object;");
                    break;
                }
                MicronautSymbolFinder.encodeType(upperBound, sb);
                break;
            }
            case INTERSECTION: {
                MicronautSymbolFinder.encodeType(((IntersectionType)type).getBounds().get(0), sb);
                break;
            }
            case ERROR: {
                TypeElement te = (TypeElement)((DeclaredType)type).asElement();
                if (te != null) {
                    sb.append('L');
                    MicronautSymbolFinder.encodeClassName(te, sb, '/');
                    sb.append(';');
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported type: %s, kind: %s", new Object[]{type, type.getKind()}));
            }
        }
    }

    private static void encodeClassName(TypeElement te, StringBuilder sb, char separator) {
        char[] nameChars = MicronautSymbolFinder.flatName(te).toCharArray();
        int charLength = nameChars.length;
        if (separator != '.') {
            for (int i = 0; i < charLength; ++i) {
                if (nameChars[i] != '.') continue;
                nameChars[i] = separator;
            }
        }
        sb.append(nameChars, 0, charLength);
    }

    private static String flatName(TypeElement te) {
        Element owner = te.getEnclosingElement();
        if (owner.getKind().isClass() || owner.getKind().isInterface()) {
            return MicronautSymbolFinder.flatName((TypeElement)owner) + '$' + te.getSimpleName();
        }
        return te.getQualifiedName().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ClassSymbolLocation> getSymbolsFromDependencies(ClasspathInfo info, String textForQuery) {
        List<ClassSymbolLocation> cached = MicronautSymbolFinder.INSTANCE.cache.get(info);
        if (cached == null) {
            JavaSource js;
            ElementHandle eh;
            info.addChangeListener(MicronautSymbolFinder.INSTANCE.cacheCleaner);
            ArrayList<ClassSymbolLocation> ret = new ArrayList<ClassSymbolLocation>();
            ClassIndex ci = info.getClassIndex();
            HashSet<ElementHandle> beanHandles = new HashSet<ElementHandle>();
            HashSet<ElementHandle> checked = new HashSet<ElementHandle>();
            LinkedList<ElementHandle> queue = new LinkedList<ElementHandle>();
            for (String ann : META_ANNOTATIONS) {
                queue.add(ElementHandle.createTypeElementHandle((ElementKind)ElementKind.ANNOTATION_TYPE, (String)ann));
            }
            while (!queue.isEmpty()) {
                eh = (ElementHandle)queue.removeFirst();
                if (!checked.add(eh)) continue;
                Set elems = ci.getElements(eh, Set.of(ClassIndex.SearchKind.TYPE_REFERENCES), Set.of(ClassIndex.SearchScope.DEPENDENCIES));
                for (ElementHandle elem : elems) {
                    if (elem.getKind() == ElementKind.ANNOTATION_TYPE) {
                        queue.add(elem);
                        continue;
                    }
                    beanHandles.add(elem);
                }
            }
            eh = ElementHandle.createTypeElementHandle((ElementKind)ElementKind.ANNOTATION_TYPE, (String)MANAGEMENT_ENDPOINT_ANNOTATION);
            Set endpointHandles = ci.getElements(eh, Set.of(ClassIndex.SearchKind.TYPE_REFERENCES), Set.of(ClassIndex.SearchScope.DEPENDENCIES));
            if (!(beanHandles.isEmpty() && endpointHandles.isEmpty() || (js = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0])) == null)) {
                try {
                    js.runUserActionTask(cc -> {
                        JavaFileObject jfo;
                        FileObject fo;
                        TypeElement symbol;
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Elements elements = cc.getElements();
                        for (ElementHandle beanHandle : beanHandles) {
                            String path;
                            Pair<AnnotationMirror, AnnotationMirror> metaAnnotated;
                            symbol = (TypeElement)beanHandle.resolve((CompilationInfo)cc);
                            if (symbol == null || (metaAnnotated = MicronautSymbolFinder.isMetaAnnotated(symbol)) == null || (fo = (jfo = elements.getFileObjectOf(symbol)) != null && jfo.getName().endsWith(".class") ? URLMapper.findFileObject((URL)jfo.toUri().toURL()) : null) == null) continue;
                            Element annEl = ((AnnotationMirror)metaAnnotated.first()).getAnnotationType().asElement();
                            String name = "@+ '" + MicronautSymbolFinder.getBeanName(symbol.getSimpleName().toString()) + "' (@" + annEl.getSimpleName() + (metaAnnotated.second() != null ? " <: @" + ((AnnotationMirror)metaAnnotated.second()).getAnnotationType().asElement().getSimpleName() : "") + ") " + symbol.getSimpleName();
                            ret.add(new ClassSymbolLocation(name, fo, symbol.getKind().name(), MicronautSymbolFinder.getSignatures(symbol)));
                            if (!CONTROLLER_ANNOTATION.contentEquals(((TypeElement)annEl).getQualifiedName()) || (path = MicronautSymbolFinder.getPath((AnnotationMirror)metaAnnotated.first())) == null) continue;
                            MicronautSymbolFinder.addEndpointSymbols(cc, fo, symbol, path, ret);
                        }
                        for (ElementHandle endpointHandle : endpointHandles) {
                            symbol = (TypeElement)endpointHandle.resolve((CompilationInfo)cc);
                            String path = symbol != null ? MicronautSymbolFinder.getPath(symbol) : null;
                            if (path == null || (fo = (jfo = elements.getFileObjectOf(symbol)) != null && jfo.getName().endsWith(".class") ? URLMapper.findFileObject((URL)jfo.toUri().toURL()) : null) == null) continue;
                            MicronautSymbolFinder.addEndpointSymbols(cc, fo, symbol, path, ret);
                        }
                    }, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            cached = ret;
            Map<ClasspathInfo, List<ClassSymbolLocation>> map = MicronautSymbolFinder.INSTANCE.cache;
            synchronized (map) {
                MicronautSymbolFinder.INSTANCE.cache.clear();
                MicronautSymbolFinder.INSTANCE.cache.put(info, ret);
            }
        }
        return cached.stream().filter(s -> s.getName().startsWith(textForQuery)).collect(Collectors.toList());
    }

    private static void addEndpointSymbols(CompilationController cc, FileObject fo, TypeElement symbol, String path, List<ClassSymbolLocation> ret) {
        for (ExecutableElement mth : ElementFilter.methodsIn(symbol.getEnclosedElements())) {
            MthIterator it = new MthIterator(mth, cc.getElements(), cc.getTypes());
            while (it.hasNext()) {
                ExecutableElement ee = it.next();
                for (AnnotationMirror annotationMirror : ee.getAnnotationMirrors()) {
                    String method = MicronautSymbolFinder.getEndpointMethod((TypeElement)annotationMirror.getAnnotationType().asElement());
                    if (method == null) continue;
                    ArrayList<String> ids = new ArrayList<String>();
                    for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                        if ("value".contentEquals(entry.getKey().getSimpleName()) || "uri".contentEquals(entry.getKey().getSimpleName())) {
                            ids.add((String)entry.getValue().getValue());
                            continue;
                        }
                        if (!"uris".contentEquals(entry.getKey().getSimpleName())) continue;
                        for (AnnotationValue av : (List)entry.getValue().getValue()) {
                            ids.add((String)av.getValue());
                        }
                    }
                    if (ids.isEmpty()) {
                        ids.add(MicronautSymbolFinder.getId(ee));
                    }
                    for (String id : ids) {
                        String name = '@' + path + id + " -- " + method;
                        ret.add(new ClassSymbolLocation(name, fo, mth.getKind().name(), MicronautSymbolFinder.getSignatures(mth)));
                    }
                }
            }
        }
    }

    public static class SymbolLocation {
        private final String name;
        private final int start;
        private final int end;
        private final int selectionStart;
        private final int selectionEnd;

        private SymbolLocation(String name, int start, int end, int selectionStart, int selectionEnd) {
            this.name = name;
            this.start = start;
            this.end = end;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }

        public String getName() {
            return this.name;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getSelectionStart() {
            return this.selectionStart;
        }

        public int getSelectionEnd() {
            return this.selectionEnd;
        }
    }

    public static class MthIterator
    implements Iterator<ExecutableElement> {
        private final ExecutableElement ee;
        private final Elements elements;
        private final Types types;
        private boolean createIt = false;
        private Iterator<ExecutableElement> it = null;

        public MthIterator(Element e, Elements elements, Types types) {
            this.ee = e != null && e.getKind() == ElementKind.METHOD ? (ExecutableElement)e : null;
            this.elements = elements;
            this.types = types;
        }

        @Override
        public boolean hasNext() {
            if (this.ee == null) {
                return false;
            }
            if (this.it == null) {
                if (!this.createIt) {
                    return true;
                }
                ArrayList<ExecutableElement> overriden = new ArrayList<ExecutableElement>();
                this.collectOverriden(this.ee, this.ee.getEnclosingElement(), overriden);
                this.it = overriden.iterator();
            }
            return this.it.hasNext();
        }

        @Override
        public ExecutableElement next() {
            if (this.it == null) {
                this.createIt = true;
                return this.ee;
            }
            return this.it.next();
        }

        private void collectOverriden(ExecutableElement orig, Element el, List<ExecutableElement> overriden) {
            for (TypeMirror typeMirror : this.types.directSupertypes(el.asType())) {
                if (typeMirror.getKind() != TypeKind.DECLARED) continue;
                Element se = ((DeclaredType)typeMirror).asElement();
                overriden.addAll(ElementFilter.methodsIn(se.getEnclosedElements()).stream().filter(me -> orig.getSimpleName().contentEquals(me.getSimpleName()) && this.elements.overrides(orig, (ExecutableElement)me, (TypeElement)el)).collect(Collectors.toList()));
                this.collectOverriden(orig, se, overriden);
            }
        }
    }

    public static class ClassSymbolLocation {
        private final String name;
        private final FileObject file;
        private final String kind;
        private final String[] signatures;

        private ClassSymbolLocation(String name, FileObject file, String kind, String[] signatures) {
            this.name = name;
            this.file = file;
            this.kind = kind;
            this.signatures = signatures;
        }

        public FileObject getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }

        public String getKind() {
            return this.kind;
        }

        public String[] getSignatures() {
            return this.signatures;
        }
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            return INSTANCE;
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            File cacheRoot = FileUtil.toFile((FileObject)context.getIndexFolder());
            for (Indexable indexable : deleted) {
                File output = new File(cacheRoot, indexable.getRelativePath() + ".mn");
                if (!output.exists()) continue;
                output.delete();
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return MicronautSymbolFinder.NAME;
        }

        public int getIndexVersion() {
            return 1;
        }
    }
}

