/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js.vars;

import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.js.vars.DebuggerSupport;
import org.netbeans.modules.debugger.jpda.js.vars.JSVariable;

public final class ScopeVariable {
    private final JPDADebugger debugger;
    private final LocalVariable lv;
    private final String name;
    private JSVariable[] scopeVars;

    private ScopeVariable(JPDADebugger debugger, LocalVariable lv) {
        this.debugger = debugger;
        this.lv = lv;
        String vv = DebuggerSupport.getVarValue(debugger, (Variable)lv);
        if (vv.startsWith("[") && vv.endsWith("]")) {
            vv = vv.substring(1, vv.length() - 1).trim();
        }
        if (vv.toLowerCase().startsWith("object")) {
            vv = vv.substring("object".length()).trim();
        }
        this.name = vv = Character.toUpperCase(vv.charAt(0)) + vv.substring(1);
    }

    public static ScopeVariable create(JPDADebugger debugger, LocalVariable lv) {
        return new ScopeVariable(debugger, lv);
    }

    public String getName() {
        return this.name;
    }

    public JSVariable[] getScopeVars() {
        if (this.scopeVars == null) {
            this.scopeVars = JSVariable.createScopeVars(this.debugger, (Variable)this.lv);
        }
        return this.scopeVars;
    }
}

