/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCrossConnectStatusRequest
extends BmcRequest<Void> {
    private String crossConnectId;

    public String getCrossConnectId() {
        return this.crossConnectId;
    }

    public Builder toBuilder() {
        return new Builder().crossConnectId(this.crossConnectId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",crossConnectId=").append(String.valueOf(this.crossConnectId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCrossConnectStatusRequest)) {
            return false;
        }
        GetCrossConnectStatusRequest other = (GetCrossConnectStatusRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.crossConnectId, other.crossConnectId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.crossConnectId == null ? 43 : this.crossConnectId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCrossConnectStatusRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String crossConnectId = null;

        public Builder crossConnectId(String crossConnectId) {
            this.crossConnectId = crossConnectId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCrossConnectStatusRequest o) {
            this.crossConnectId(o.getCrossConnectId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCrossConnectStatusRequest build() {
            GetCrossConnectStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCrossConnectStatusRequest buildWithoutInvocationCallback() {
            GetCrossConnectStatusRequest request = new GetCrossConnectStatusRequest();
            request.crossConnectId = this.crossConnectId;
            return request;
        }
    }
}

