/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConsoleHistoryRequest
extends BmcRequest<Void> {
    private String instanceConsoleHistoryId;

    public String getInstanceConsoleHistoryId() {
        return this.instanceConsoleHistoryId;
    }

    public Builder toBuilder() {
        return new Builder().instanceConsoleHistoryId(this.instanceConsoleHistoryId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceConsoleHistoryId=").append(String.valueOf(this.instanceConsoleHistoryId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConsoleHistoryRequest)) {
            return false;
        }
        GetConsoleHistoryRequest other = (GetConsoleHistoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceConsoleHistoryId, other.instanceConsoleHistoryId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceConsoleHistoryId == null ? 43 : this.instanceConsoleHistoryId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConsoleHistoryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceConsoleHistoryId = null;

        public Builder instanceConsoleHistoryId(String instanceConsoleHistoryId) {
            this.instanceConsoleHistoryId = instanceConsoleHistoryId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConsoleHistoryRequest o) {
            this.instanceConsoleHistoryId(o.getInstanceConsoleHistoryId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConsoleHistoryRequest build() {
            GetConsoleHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConsoleHistoryRequest buildWithoutInvocationCallback() {
            GetConsoleHistoryRequest request = new GetConsoleHistoryRequest();
            request.instanceConsoleHistoryId = this.instanceConsoleHistoryId;
            return request;
        }
    }
}

