/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ChangeDrgCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeDrgCompartmentRequest
extends BmcRequest<ChangeDrgCompartmentDetails> {
    private String drgId;
    private ChangeDrgCompartmentDetails changeDrgCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDrgId() {
        return this.drgId;
    }

    public ChangeDrgCompartmentDetails getChangeDrgCompartmentDetails() {
        return this.changeDrgCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeDrgCompartmentDetails getBody$() {
        return this.changeDrgCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().drgId(this.drgId).changeDrgCompartmentDetails(this.changeDrgCompartmentDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",drgId=").append(String.valueOf(this.drgId));
        sb.append(",changeDrgCompartmentDetails=").append(String.valueOf((Object)this.changeDrgCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeDrgCompartmentRequest)) {
            return false;
        }
        ChangeDrgCompartmentRequest other = (ChangeDrgCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.drgId, other.drgId) && Objects.equals((Object)this.changeDrgCompartmentDetails, (Object)other.changeDrgCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.drgId == null ? 43 : this.drgId.hashCode());
        result = result * 59 + (this.changeDrgCompartmentDetails == null ? 43 : this.changeDrgCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeDrgCompartmentRequest, ChangeDrgCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String drgId = null;
        private ChangeDrgCompartmentDetails changeDrgCompartmentDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder drgId(String drgId) {
            this.drgId = drgId;
            return this;
        }

        public Builder changeDrgCompartmentDetails(ChangeDrgCompartmentDetails changeDrgCompartmentDetails) {
            this.changeDrgCompartmentDetails = changeDrgCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeDrgCompartmentRequest o) {
            this.drgId(o.getDrgId());
            this.changeDrgCompartmentDetails(o.getChangeDrgCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeDrgCompartmentRequest build() {
            ChangeDrgCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeDrgCompartmentDetails body) {
            this.changeDrgCompartmentDetails(body);
            return this;
        }

        public ChangeDrgCompartmentRequest buildWithoutInvocationCallback() {
            ChangeDrgCompartmentRequest request = new ChangeDrgCompartmentRequest();
            request.drgId = this.drgId;
            request.changeDrgCompartmentDetails = this.changeDrgCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

