/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class AntBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final String ANT_MIME_TYPE = "text/x-ant+xml";
    private static final Set actions = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    EditorContextDispatcher context = EditorContextDispatcher.getDefault();

    public AntBreakpointActionProvider() {
        this.context.addPropertyChangeListener(ANT_MIME_TYPE, WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.context));
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
    }

    public void doAction(Object action) {
        int i;
        Line line = AntBreakpointActionProvider.getCurrentLine();
        if (line == null) {
            return;
        }
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = breakpoints.length;
        for (i = 0; i < k; ++i) {
            if (!(breakpoints[i] instanceof AntBreakpoint) || !((AntBreakpoint)breakpoints[i]).getLine().equals(line)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpoints[i]);
            break;
        }
        if (i == k) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)new AntBreakpoint(line));
        }
    }

    public Set getActions() {
        return actions;
    }

    private static Line getCurrentLine() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (!AntBreakpointActionProvider.isAntFile(fo)) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    private static boolean isAntFile(FileObject fo) {
        if (fo == null) {
            return false;
        }
        return fo.getMIMEType().equals(ANT_MIME_TYPE);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = AntBreakpointActionProvider.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, enabled);
    }
}

