/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.groovy.editor.api.ElementUtils;
import org.netbeans.modules.groovy.refactoring.findusages.model.MethodRefactoringElement;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.ui.RefactoringModule;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedPanel;
import org.netbeans.modules.groovy.refactoring.utils.FindPossibleMethods;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WhereUsedPanelMethod
extends WhereUsedPanel.WhereUsedInnerPanel {
    private static final long serialVersionUID = 1L;
    private static EmptyImageIcon EMPTY_IMAGE_ICON;
    private JRadioButton btn_overriders;
    private JRadioButton btn_usages;
    private JRadioButton btn_usages_overriders;
    private ButtonGroup buttonGroup1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel label;
    private JLabel lbl_usagesof;
    private JCheckBox searchInComments;

    public WhereUsedPanelMethod() {
        this.initComponents();
        this.jComboBox1.setRenderer(new ComboBoxRenderer());
    }

    @Override
    void initialize(final RefactoringElement element) {
        assert (element instanceof MethodRefactoringElement);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WhereUsedPanelMethod.this.initUI(element);
                WhereUsedPanelMethod.this.initClassTypeComboBox((MethodRefactoringElement)element);
            }
        });
    }

    private void initUI(RefactoringElement element) {
        Set<Modifier> modifiers = element.getModifiers();
        ImageIcon labelIcon = UiUtils.getElementIcon((ElementKind)element.getKind(), element.getModifiers());
        String labelText = element.getShowcase();
        Dimension preferredSize = this.label.getPreferredSize();
        this.label.setText(labelText);
        this.label.setIcon(labelIcon);
        this.label.setPreferredSize(preferredSize);
        this.label.setMinimumSize(preferredSize);
        this.btn_usages.setVisible(!modifiers.contains(Modifier.STATIC));
        this.btn_overriders.setVisible(!modifiers.contains(Modifier.STATIC) && !modifiers.contains(Modifier.PRIVATE) && element.getKind() != ElementKind.CONSTRUCTOR);
        this.btn_usages_overriders.setVisible(this.btn_usages.isVisible() && this.btn_overriders.isVisible());
    }

    private void initClassTypeComboBox(final MethodRefactoringElement element) {
        ClassNode methodType = element.getMethodType();
        if (methodType != null) {
            this.jComboBox1.setModel(new DefaultComboBoxModel<ClassNode>(new ClassNode[]{methodType}));
            this.jComboBox1.setEnabled(false);
        } else {
            FileObject fo = element.getFileObject();
            String fqn = element.getNode().getText();
            String methodName = element.getName();
            Set<MethodNode> possibleMethods = FindPossibleMethods.findPossibleMethods(fo, fqn, methodName);
            HashSet<ClassNode> possibleClasses = new HashSet<ClassNode>();
            for (MethodNode method : possibleMethods) {
                possibleClasses.add(method.getDeclaringClass());
            }
            this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(possibleClasses.toArray()));
            this.jComboBox1.setEnabled(true);
            element.setMethodType((ClassNode)possibleClasses.iterator().next());
        }
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                element.setMethodType((ClassNode)WhereUsedPanelMethod.this.jComboBox1.getSelectedItem());
            }
        });
    }

    public boolean isMethodFromBaseClass() {
        return this.jComboBox1.getSelectedIndex() > 0;
    }

    public boolean isMethodOverriders() {
        return this.btn_overriders.isSelected() || this.btn_usages_overriders.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.btn_usages.isSelected() || this.btn_usages_overriders.isSelected();
    }

    @Override
    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    private static Icon getEmptyIcon() {
        if (EMPTY_IMAGE_ICON == null) {
            EMPTY_IMAGE_ICON = new EmptyImageIcon();
        }
        return EMPTY_IMAGE_ICON;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.lbl_usagesof = new JLabel();
        this.btn_usages = new JRadioButton();
        this.btn_overriders = new JRadioButton();
        this.btn_usages_overriders = new JRadioButton();
        this.label.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/groovy/refactoring/resources/warning_16.png")));
        this.label.setText("<<Element>>");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanelMethod.class).getString("LBL_SearchInComents"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"WhereUsedPanelMethod.jLabel1.text"));
        this.jComboBox1.setModel(new DefaultComboBoxModel<JLabel>(new JLabel[]{this.label}));
        Mnemonics.setLocalizedText((JLabel)this.lbl_usagesof, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"LBL_UsagesOfElement"));
        this.buttonGroup1.add(this.btn_usages);
        this.btn_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.btn_usages, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"LBL_FindUsages"));
        this.buttonGroup1.add(this.btn_overriders);
        Mnemonics.setLocalizedText((AbstractButton)this.btn_overriders, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"LBL_FindOverridingMethods"));
        this.buttonGroup1.add(this.btn_usages_overriders);
        Mnemonics.setLocalizedText((AbstractButton)this.btn_usages_overriders, (String)NbBundle.getMessage(WhereUsedPanelMethod.class, (String)"LBL_FindUsagesOverridingMethods"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lbl_usagesof).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btn_usages_overriders).addComponent(this.btn_usages).addComponent(this.searchInComments).addComponent(this.btn_overriders)).addGap(0, 33, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbl_usagesof).addComponent(this.label)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchInComments).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_usages).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_overriders).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btn_usages_overriders).addGap(8, 8, 8)));
    }

    private static class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value instanceof ClassNode) {
                ClassNode classNode = (ClassNode)value;
                this.setText(ElementUtils.getNameWithoutPackage((ASTNode)classNode));
                if (classNode.isInterface()) {
                    this.setIcon(UiUtils.getElementIcon((ElementKind)ElementKind.INTERFACE, null));
                } else {
                    this.setIcon(UiUtils.getElementIcon((ElementKind)ElementKind.CLASS, null));
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private static class EmptyImageIcon
    implements Icon {
        private static final int WIDTH = 16;
        private static final int HEIGHT = 16;

        private EmptyImageIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 16;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }
}

