/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools.scopes;

import eu.hansolo.jdktools.scopes.Scope;
import java.util.Arrays;
import java.util.List;

public enum BuildScope implements Scope
{
    BUILD_OF_OPEN_JDK("Build of OpenJDK", "build_of_openjdk"),
    BUILD_OF_GRAALVM("Build of GraalVM", "build_of_graalvm");

    private final String uiString;
    private final String apiString;

    private BuildScope(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    public static Scope fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        switch (text) {
            case "build_of_openjdk": 
            case "BuildOfOpenJDK": 
            case "buildofopenjdk": 
            case "BUILD_OF_OPENJDK": {
                return BUILD_OF_OPEN_JDK;
            }
            case "build_of_graalvm": 
            case "BuildOfGraalVM": 
            case "buildofgraalvm": 
            case "BUILD_OF_GRAALVM": {
                return BUILD_OF_GRAALVM;
            }
        }
        return NOT_FOUND;
    }

    public static List<BuildScope> getAsList() {
        return Arrays.asList(BuildScope.values());
    }
}

