/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ResourceHyperlinkProcessor
extends HyperlinkProcessor {
    @Override
    public void process(HyperlinkEnv env) {
        FileObject fo = env.getFileObject();
        if (fo == null) {
            return;
        }
        FileObject parent = fo.getParent();
        String value = env.getValueString();
        if (value.contains("classpath") ? ResourceHyperlinkProcessor.openFromClasspath(fo, value) : ResourceHyperlinkProcessor.openFile(parent.getFileObject(env.getValueString()))) {
            return;
        }
        String message = NbBundle.getMessage(ResourceHyperlinkProcessor.class, (String)"LBL_ResourceNotFound", (Object)env.getValueString());
        StatusDisplayer.getDefault().setStatusText(message);
    }

    private static boolean openFromClasspath(FileObject fo, String value) {
        int colonOffset = value.indexOf(":");
        String subPath = value.substring(colonOffset + 1);
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project != null) {
            ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
            Sources sources = ProjectUtils.getSources((Project)project);
            groups.addAll(Arrays.asList(sources.getSourceGroups("doc_root")));
            groups.addAll(Arrays.asList(sources.getSourceGroups("java")));
            for (SourceGroup sourceGroup : groups) {
                FileObject fileObject = sourceGroup.getRootFolder().getFileObject(subPath);
                if (fileObject == null) continue;
                ResourceHyperlinkProcessor.openFile(fileObject);
                return true;
            }
        }
        return false;
    }

    private static boolean openFile(FileObject file) {
        DataObject dObj;
        if (file == null) {
            return false;
        }
        try {
            dObj = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return false;
        }
        EditorCookie editorCookie = (EditorCookie)dObj.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return false;
        }
        editorCookie.open();
        return true;
    }
}

