/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.navigation.base.Filters;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.actions.Presenter;

public class SortActions {
    private SortActions() {
        throw new IllegalStateException("No instance allowed.");
    }

    @NonNull
    public static Action createSortByNameAction(@NonNull Filters<?> filters) {
        Parameters.notNull((CharSequence)"filters", filters);
        return new SortByNameAction(filters);
    }

    @NonNull
    public static Action createSortBySourceAction(@NonNull Filters<?> filters) {
        Parameters.notNull((CharSequence)"filters", filters);
        return new SortBySourceAction(filters);
    }

    private static final class SortByNameAction
    extends BaseSortAction {
        private static final String ICON = "org/netbeans/modules/java/navigation/resources/sortAlpha.png";

        public SortByNameAction(@NonNull Filters<?> filters) {
            super(filters);
            this.putValue("Name", NbBundle.getMessage(SortByNameAction.class, (String)"LBL_SortByName"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)ICON, (boolean)false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filters.setNaturalSort(false);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(!this.filters.isNaturalSort());
        }
    }

    private static final class SortBySourceAction
    extends BaseSortAction {
        private static final String ICON = "org/netbeans/modules/java/navigation/resources/sortPosition.png";

        public SortBySourceAction(@NonNull Filters<?> filters) {
            super(filters);
            this.putValue("Name", NbBundle.getMessage(SortBySourceAction.class, (String)"LBL_SortBySource"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)ICON, (boolean)false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filters.setNaturalSort(true);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(this.filters.isNaturalSort());
        }
    }

    private static abstract class BaseSortAction
    extends AbstractAction
    implements Presenter.Popup {
        public static final String SELECTED = "selected";
        protected final Filters<?> filters;
        private JRadioButtonMenuItem menuItem;

        public BaseSortAction(@NonNull Filters<?> filters) {
            assert (filters != null);
            this.filters = filters;
        }

        @NonNull
        public final JMenuItem getPopupPresenter() {
            JRadioButtonMenuItem result = this.obtainMenuItem();
            this.updateMenuItem();
            return result;
        }

        @NonNull
        protected final JRadioButtonMenuItem obtainMenuItem() {
            if (this.menuItem == null) {
                this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
                this.menuItem.setAction(this);
            }
            return this.menuItem;
        }

        protected abstract void updateMenuItem();
    }
}

