/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.checkout;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.checkout.CheckoutPaths;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;

public class CheckoutPathsAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CheckoutPathsAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        CheckoutPaths checkout = new CheckoutPaths(repository, roots);
        if (checkout.show()) {
            this.checkoutFiles(repository, roots, checkout.getRevision());
        }
    }

    public void checkoutFiles(File repository, final File[] roots, final String revision) {
        GitProgressSupport supp = new GitProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                final HashSet notifiedFiles = new HashSet();
                try {
                    final GitClient client = this.getClient();
                    client.addNotificationListener((NotificationListener)new FileListener(){

                        public void notifyFile(File file, String relativePathToRoot) {
                            notifiedFiles.add(file);
                        }
                    });
                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(roots));
                    final File[][] split = Utils.splitFlatOthers((File[])roots);
                    GitUtils.runWithoutIndexing(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            for (int c = 0; c < split.length; ++c) {
                                File[] splitRoots = split[c];
                                if (splitRoots.length == 0) continue;
                                if (c == 1) {
                                    LOG.log(Level.FINE, "Checking out paths recursively, revision: {0}", revision);
                                    client.checkout(splitRoots, revision, true, this.getProgressMonitor());
                                    continue;
                                }
                                LOG.log(Level.FINE, "Checking out paths non-recursively, revision: {0}", revision);
                                client.checkout(splitRoots, revision, false, this.getProgressMonitor());
                            }
                            return null;
                        }
                    }, roots);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    if (!notifiedFiles.isEmpty()) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), notifiedFiles));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_CheckoutPaths.progressName"));
    }
}

