/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;

public class GdbVersionPeculiarity {
    private final Version version;
    private final Platform platform;
    private final Set<String> features = Collections.synchronizedSet(new HashSet());
    private final boolean lldb = "true".equals(System.getProperty("cnd.debugger.lldb"));
    private static final boolean DISABLE_PENDING = Boolean.getBoolean("gdb.breakpoints.pending.disabled");

    private GdbVersionPeculiarity(Version version, Platform platform) {
        this.version = version;
        this.platform = platform;
    }

    public static GdbVersionPeculiarity create(Version version, Platform platform) {
        return new GdbVersionPeculiarity(version, platform);
    }

    public String environmentDirectoryCommand() {
        if (this.version.compareTo(6, 3) > 0 || this.platform == Platform.MacOSX_x86) {
            return "-environment-directory";
        }
        return "directory";
    }

    public String environmentCdCommand() {
        if (this.version.compareTo(6, 3) > 0) {
            return "-environment-cd";
        }
        return "cd";
    }

    public String execAbortCommand() {
        if (this.version.compareTo(6, 6) > 0) {
            return "-exec-abort";
        }
        return "kill";
    }

    public String execStepCommand(String thread) {
        if (this.version.compareTo(7, 4) >= 0 || this.lldb) {
            return "-exec-step --thread " + thread;
        }
        return "-exec-step";
    }

    public String execNextCommand(String thread) {
        if (this.version.compareTo(7, 4) >= 0 || this.lldb) {
            return "-exec-next --thread " + thread;
        }
        return "-exec-next";
    }

    public String execStepInstCommand(String thread) {
        if (this.version.compareTo(7, 4) >= 0 || this.lldb) {
            return "-exec-step-instruction --thread " + thread;
        }
        return "-exec-step-instruction";
    }

    public String execNextInstCommand(String thread) {
        if (this.version.compareTo(7, 4) >= 0 || this.lldb) {
            return "-exec-next-instruction --thread " + thread;
        }
        return "-exec-next-instruction";
    }

    public String execFinishCommand(String thread) {
        if (this.lldb) {
            return "-exec-finish --thread " + thread;
        }
        return "-exec-finish";
    }

    public String listChildrenCommand(String expr, int start, int end) {
        StringBuilder retVal = new StringBuilder();
        if (this.lldb) {
            retVal.append("-var-list-children --all-values ").append(expr);
        } else {
            retVal.append("-var-list-children --all-values \"").append(expr).append("\"");
        }
        if (this.version.compareTo(6, 8) > 0) {
            retVal.append(" ").append(start).append(" ").append(end);
        }
        return retVal.toString();
    }

    public String showAttributesCommand(String expr) {
        if (this.lldb) {
            return "-var-show-attributes " + expr;
        }
        return "-var-show-attributes \"" + expr + "\"";
    }

    public boolean isLldb() {
        return this.lldb;
    }

    public boolean isThreadsOutputUnusual() {
        return this.platform == Platform.MacOSX_x86;
    }

    public boolean isLocalsOutputUnusual() {
        return this.platform == Platform.MacOSX_x86 && this.version.compareTo(6, 3) <= 0;
    }

    public boolean isSyscallBreakpointsSupported() {
        return this.platform != Platform.MacOSX_x86;
    }

    public String breakPendingFlag() {
        if (!(DISABLE_PENDING || this.version.compareTo(6, 8) < 0 && this.platform != Platform.MacOSX_x86)) {
            return " -f";
        }
        return "";
    }

    public String breakDisabledFlag() {
        if (this.version.compareTo(6, 8) >= 0 || this.platform == Platform.MacOSX_x86) {
            return " -d";
        }
        return "";
    }

    public String createVarCommand(String expr, String thread, String frame) {
        if (this.lldb) {
            return "-var-create - @ " + expr + " --thread " + thread + " --frame " + frame;
        }
        return "-var-create - @ " + expr;
    }

    public String stackListFramesCommand(String thread) {
        if (this.version.compareTo(7, 4) >= 0 || this.lldb) {
            return "-stack-list-frames --thread " + thread;
        }
        return "-stack-list-frames";
    }

    public String stackListLocalsCommand() {
        return "-stack-list-variables --no-values";
    }

    public boolean isSupported() {
        return this.version.compareTo(6, 8) >= 0 || this.platform == Platform.MacOSX_x86 && this.version.compareTo(6, 3) >= 0;
    }

    public boolean supports(Feature feature) {
        return this.features.contains(feature.command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFeatures(MIRecord result) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.clear();
            try {
                MITList results = result.results();
                MIValue value = ((MIResult)results.get(0)).value();
                for (MITListItem item : value.asList()) {
                    this.features.add(((MIConst)item).value());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum Feature {
        THREAD_INFO("thread-info"),
        BREAKPOINT_NOTIFICATIONS("breakpoint-notifications");

        private final String command;

        private Feature(String command) {
            this.command = command;
        }
    }

    public static final class Version {
        final int before;
        final int after;

        public Version(int before, int after) {
            this.before = before;
            this.after = after;
        }

        public int compareTo(int before, int after) {
            int beforeDiff = this.before - before;
            if (beforeDiff == 0) {
                return this.after - after;
            }
            return beforeDiff;
        }

        public String toString() {
            return String.format("%d.%d", this.before, this.after);
        }
    }
}

