/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.analysis.PHPStanParams;
import org.netbeans.modules.php.analysis.commands.Bundle;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.parsers.CheckStyleReportParser;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class PHPStan {
    public static final String NAME = "phpstan";
    public static final String LONG_NAME = "phpstan.phar";
    public static final String MAX_LEVEL = "max";
    static final File XML_LOG = new File(System.getProperty("java.io.tmpdir"), "nb-php-phpstan-log.xml");
    private static final Logger LOGGER = Logger.getLogger(PHPStan.class.getName());
    private static final String ANALYSE_COMMAND = "analyse";
    private static final String CONFIGURATION_PARAM = "--configuration=%s";
    private static final String LEVEL_PARAM = "--level=%s";
    private static final String MEMORY_LIMIT_PARAM = "--memory-limit=%s";
    private static final String ERROR_FORMAT_PARAM = "--error-format=checkstyle";
    private static final String NO_PROGRESS_PARAM = "--no-progress";
    private static final String NO_INTERACTION_PARAM = "--no-interaction";
    private static final String ANSI_PARAM = "--ansi";
    private static final String NO_ANSI_PARAM = "--no-ansi";
    private static final String VERSION_PARAM = "--version";
    private static final String VERBOSE_PARAM = "--verbose";
    private static final List<String> ANALYZE_DEFAULT_PARAMS = Arrays.asList("--no-ansi", "--no-progress", "--no-interaction", "--error-format=checkstyle");
    public static final String CONFIG_FILE_NAME = "phpstan.neon";
    public static final String DIST_CONFIG_FILE_NAME = "phpstan.neon.dist";
    public static final String ALTERNATIVE_DIST_CONFIG_FILE_NAME = "phpstan.dist.neon";
    private final String phpStanPath;
    private int analyzeGroupCounter = 1;

    private PHPStan(String phpStanPath) {
        this.phpStanPath = phpStanPath;
    }

    public static PHPStan getDefault() throws InvalidPhpExecutableException {
        return PHPStan.getCustom(AnalysisOptions.getInstance().getPHPStanPath());
    }

    public static PHPStan getCustom(String phpStanPath) throws InvalidPhpExecutableException {
        String error = PHPStan.validate(phpStanPath);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new PHPStan(phpStanPath);
    }

    public static String validate(String phpStanPath) {
        return PhpExecutableValidator.validateCommand((String)phpStanPath, (String)Bundle.PHPStan_script_label());
    }

    public void startAnalyzeGroup() {
        this.analyzeGroupCounter = 1;
    }

    @CheckForNull
    public List<Result> analyze(PHPStanParams params, FileObject file) {
        assert (file.isValid()) : "Invalid file given: " + file;
        try {
            FileObject workDir = this.findWorkDir(file);
            Integer result = this.getExecutable(Bundle.PHPStan_analyze(this.analyzeGroupCounter++), workDir == null ? null : FileUtil.toFile((FileObject)workDir)).additionalParameters(this.getParameters(params, file)).runAndWait(this.getDescriptor(), "Running phpstan...");
            if (result == null) {
                return null;
            }
            return CheckStyleReportParser.parse(XML_LOG, file, workDir);
        }
        catch (CancellationException ex) {
            return Collections.emptyList();
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            UiUtils.processExecutionException((ExecutionException)ex, (String)"CodeAnalysis");
            return null;
        }
    }

    @CheckForNull
    private FileObject findWorkDir(FileObject file) {
        assert (file != null);
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        FileObject workDir = null;
        if (project != null) {
            workDir = project.getProjectDirectory();
            if (LOGGER.isLoggable(Level.FINE)) {
                if (workDir != null) {
                    LOGGER.log(Level.FINE, "Project directory for {0} is found in {1}", new Object[]{FileUtil.toFile((FileObject)file), workDir});
                } else {
                    LOGGER.log(Level.FINE, "Project directory for {0} is not found", FileUtil.toFile((FileObject)file));
                }
            }
        }
        return workDir;
    }

    private PhpExecutable getExecutable(String title, @NullAllowed File workDir) {
        PhpExecutable executable = new PhpExecutable(this.phpStanPath).optionsSubcategory("CodeAnalysis").fileOutput(XML_LOG, "UTF-8", false).redirectErrorStream(false).displayName(title);
        if (workDir != null) {
            executable.workDir(workDir);
        }
        return executable;
    }

    private ExecutionDescriptor getDescriptor() {
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/CodeAnalysis").frontWindowOnError(false).inputVisible(false).preExecution(() -> {
            if (XML_LOG.isFile() && !XML_LOG.delete()) {
                LOGGER.log(Level.INFO, "Cannot delete log file {0}", XML_LOG.getAbsolutePath());
            }
        });
    }

    private List<String> getParameters(PHPStanParams parameters, FileObject file) {
        String memoryLimit;
        FileObject configuration;
        ArrayList<String> params = new ArrayList<String>();
        params.add(ANALYSE_COMMAND);
        params.addAll(ANALYZE_DEFAULT_PARAMS);
        String level = parameters.getLevel();
        if (!StringUtils.isEmpty((String)level)) {
            params.add(String.format(LEVEL_PARAM, level));
        }
        if ((configuration = parameters.getConfiguration()) != null) {
            params.add(String.format(CONFIGURATION_PARAM, FileUtil.toFile((FileObject)configuration).getAbsolutePath()));
        }
        if (!StringUtils.isEmpty((String)(memoryLimit = parameters.getMemoryLimit()))) {
            params.add(String.format(MEMORY_LIMIT_PARAM, memoryLimit));
        }
        params.add(FileUtil.toFile((FileObject)file).getAbsolutePath());
        return params;
    }
}

