/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

public class BraceHighlighting
implements BracesMatcher,
BracesMatcherFactory {
    private static final Logger LOG = Logger.getLogger(BraceHighlighting.class.getName());
    private static final Map<Language, Map<String, Set<String>>[]> PAIRS = new WeakHashMap<Language, Map<String, Set<String>>[]>();
    private final MatcherContext context;
    private final String topLevelMimeType;
    private TokenSequence<?> seq;
    private int seqStart;
    private int seqEnd;
    private String originText;
    private Map<String, Set<String>> pairsMap;
    private boolean backwards;
    private BracesMatcher defaultMatcher;

    public BraceHighlighting(String topLevelMimeType) {
        this(topLevelMimeType, null);
    }

    public BraceHighlighting(String topLevelMimeType, MatcherContext context) {
        this.topLevelMimeType = topLevelMimeType;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Object ts;
            Language language = null;
            try {
                language = LanguagesManager.getDefault().getLanguage(this.topLevelMimeType);
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
            TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
            if (language == null || th == null) {
                int[] nArray = this.defaultFindOrigin(this.context);
                return nArray;
            }
            int caretOffset = this.context.getSearchOffset();
            boolean searchBack = this.context.isSearchingBackward();
            List sequences = th.embeddedTokenSequences(caretOffset, searchBack);
            for (int i = sequences.size() - 1; i >= 0; --i) {
                ts = (TokenSequence)sequences.get(i);
                if (!ts.language().mimeType().equals(language.getMimeType())) continue;
                this.seq = ts;
                if (i > 0) {
                    TokenSequence outerSeq = (TokenSequence)sequences.get(i - 1);
                    this.seqStart = outerSeq.offset();
                    this.seqEnd = outerSeq.offset() + outerSeq.token().length();
                    break;
                }
                this.seqStart = 0;
                this.seqEnd = this.context.getDocument().getLength();
                break;
            }
            if (this.seq == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TokenSequence with wrong language " + language);
                }
                int[] i = null;
                return i;
            }
            Map<String, Set<String>>[] pairsMaps = BraceHighlighting.getPairsMap(language);
            if (pairsMaps == null) {
                ts = this.defaultFindOrigin(this.context);
                return ts;
            }
            this.seq.move(caretOffset);
            if (this.seq.moveNext()) {
                boolean[] bckwrd = new boolean[1];
                String tokenText = this.seq.token().text().toString();
                String trimedTokenText = tokenText.trim();
                if (BraceHighlighting.isOrigin(pairsMaps, trimedTokenText, bckwrd) && (this.seq.offset() < caretOffset || !searchBack)) {
                    this.originText = trimedTokenText;
                    this.backwards = bckwrd[0];
                    this.pairsMap = this.backwards ? pairsMaps[1] : pairsMaps[0];
                    int offset = this.seq.offset() + tokenText.indexOf(trimedTokenText);
                    int length = trimedTokenText.length();
                    int[] nArray = new int[]{offset, offset + length};
                    return nArray;
                }
                while (BraceHighlighting.moveTheSequence(this.seq, searchBack, this.context.getLimitOffset())) {
                    tokenText = this.seq.token().text().toString();
                    trimedTokenText = tokenText.trim();
                    if (!BraceHighlighting.isOrigin(pairsMaps, trimedTokenText, bckwrd)) continue;
                    this.originText = trimedTokenText;
                    this.backwards = bckwrd[0];
                    this.pairsMap = this.backwards ? pairsMaps[1] : pairsMaps[0];
                    int offset = this.seq.offset() + tokenText.indexOf(trimedTokenText);
                    int length = trimedTokenText.length();
                    int[] nArray = new int[]{offset, offset + length};
                    return nArray;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            if (this.defaultMatcher != null) {
                int[] nArray = this.defaultMatcher.findMatches();
                return nArray;
            }
            assert (this.seq != null) : "No token sequence";
            ArrayList<String> unresolved = new ArrayList<String>();
            unresolved.add(this.originText);
            while (BraceHighlighting.moveTheSequence(this.seq, this.backwards, -1)) {
                String tokenText = this.seq.token().text().toString();
                String trimedTokenText = tokenText.trim();
                int depth = unresolved.size() - 1;
                String currentOrigin = (String)unresolved.get(depth);
                Set<String> matchingTexts = this.pairsMap.get(currentOrigin);
                if (matchingTexts != null && matchingTexts.contains(trimedTokenText)) {
                    unresolved.remove(depth);
                    if (unresolved.size() != 0) continue;
                    int offset = this.seq.offset() + tokenText.indexOf(trimedTokenText);
                    int length = trimedTokenText.length();
                    int[] nArray = new int[]{offset, offset + length};
                    return nArray;
                }
                if (!this.pairsMap.containsKey(trimedTokenText)) continue;
                unresolved.add(trimedTokenText);
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    public BracesMatcher createMatcher(MatcherContext context) {
        return new BraceHighlighting(this.topLevelMimeType, context);
    }

    private static Map<String, Set<String>>[] getPairsMap(Language l) {
        if (!PAIRS.containsKey(l)) {
            HashMap<String, HashSet<String>> startToEnd = new HashMap<String, HashSet<String>>();
            HashMap<String, HashSet<String>> endToStart = new HashMap<String, HashSet<String>>();
            List<Feature> indents = l.getFeatureList().getFeatures("BRACE");
            for (Feature indent : indents) {
                String s = (String)indent.getValue();
                int i = s.indexOf(58);
                String start = s.substring(0, i);
                String end = s.substring(i + 1);
                HashSet<String> matchTextsEnd = (HashSet<String>)startToEnd.get(start);
                if (matchTextsEnd == null) {
                    matchTextsEnd = new HashSet<String>();
                    startToEnd.put(start, matchTextsEnd);
                }
                matchTextsEnd.add(end);
                HashSet<String> matchTextsStart = (HashSet<String>)endToStart.get(end);
                if (matchTextsStart == null) {
                    matchTextsStart = new HashSet<String>();
                    endToStart.put(end, matchTextsStart);
                }
                matchTextsStart.add(start);
            }
            Map[] arr = new Map[]{startToEnd, endToStart};
            PAIRS.put(l, arr);
        }
        return PAIRS.get(l);
    }

    private static boolean moveTheSequence(TokenSequence<?> seq, boolean backward, int offsetLimit) {
        if (backward) {
            if (seq.movePrevious()) {
                int e = seq.offset() + seq.token().length();
                return offsetLimit == -1 ? true : e > offsetLimit;
            }
        } else if (seq.moveNext()) {
            int s = seq.offset();
            return offsetLimit == -1 ? true : s < offsetLimit;
        }
        return false;
    }

    private static boolean isOrigin(Map<String, Set<String>>[] pairsMaps, String originText, boolean[] backwards) {
        Set<String> s = pairsMaps[0].get(originText);
        if (s != null && s.size() > 0) {
            backwards[0] = false;
            return true;
        }
        s = pairsMaps[1].get(originText);
        if (s != null && s.size() > 0) {
            backwards[0] = true;
            return true;
        }
        return false;
    }

    private int[] defaultFindOrigin(MatcherContext context) throws InterruptedException, BadLocationException {
        this.defaultMatcher = BracesMatcherSupport.defaultMatcher((MatcherContext)context, (int)-1, (int)-1);
        return this.defaultMatcher.findOrigin();
    }
}

