/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.modules.properties.BundleEditPanel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleEvent;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.Util;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PropertiesTableModel
extends AbstractTableModel {
    static final long serialVersionUID = -7882925922830244768L;
    private BundleStructure structure;
    private PropertyBundleListener bundleListener;

    public PropertiesTableModel(BundleStructure structure) {
        this.structure = structure;
        this.bundleListener = new TablePropertyBundleListener();
        structure.addPropertyBundleListener((PropertyBundleListener)WeakListeners.create(PropertyBundleListener.class, (EventListener)this.bundleListener, (Object)structure));
    }

    public Class getColumnClass(int columnIndex) {
        return StringPair.class;
    }

    @Override
    public int getRowCount() {
        return this.structure.getKeyCount();
    }

    @Override
    public int getColumnCount() {
        return this.structure.getEntryCount() + 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Element.ItemElem item;
        BundleStructure bs = this.structure;
        if (column == 0) {
            return this.stringPairForKey(row);
        }
        try {
            item = bs.getItem(column - 1, bs.keyAt(row));
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            item = null;
        }
        return this.stringPairForValue(item);
    }

    private StringPair stringPairForKey(int row) {
        BundleStructure bs = this.structure;
        Element.ItemElem item = bs.getItem(0, bs.keyAt(row));
        StringPair sp = item == null ? new StringPair("", bs.keyAt(row), true) : new StringPair(item.getComment(), bs.keyAt(row), true);
        if (this.structure.getEntryCount() > 1) {
            sp.setCommentEditable(false);
        }
        return sp;
    }

    private StringPair stringPairForValue(Element.ItemElem item) {
        if (item == null) {
            return new StringPair(null, null);
        }
        return new StringPair(item.getComment(), item.getValue());
    }

    @Override
    public String getColumnName(int column) {
        String leading = column == this.structure.getSortIndex() ? "     " : " ";
        if (column == 0) {
            return leading + NbBundle.getBundle(PropertiesTableModel.class).getString("LAB_KeyColumnLabel");
        }
        if (this.structure.getEntryCount() == 1) {
            return leading + NbBundle.getBundle(PropertiesTableModel.class).getString("LBL_ColumnValue");
        }
        PropertiesFileEntry entry = this.structure.getNthEntry(column - 1);
        return entry == null ? "" : leading + Util.getLocaleLabel((MultiDataObject.Entry)entry);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue.equals(this.getValueAt(rowIndex, columnIndex))) {
            return;
        }
        if (columnIndex == 0) {
            BundleStructure bs = this.structure;
            String oldValue = bs.keyAt(rowIndex);
            if (oldValue == null) {
                return;
            }
            String newValue = ((StringPair)aValue).getValue();
            if (newValue == null) {
                return;
            }
            for (int i = 0; i < this.structure.getEntryCount(); ++i) {
                Element.ItemElem item;
                PropertiesStructure ps;
                PropertiesFileEntry entry = this.structure.getNthEntry(i);
                if (entry == null || (ps = entry.getHandler().getStructure()) == null) continue;
                if (!oldValue.equals(newValue)) {
                    ps.renameItem(oldValue, newValue);
                    this.structure.sort(-1);
                }
                if (i != 0 || (item = ps.getItem(newValue)) == null || !((StringPair)aValue).isCommentEditable() || item.getComment().equals(((StringPair)aValue).getComment())) continue;
                item.setComment(((StringPair)aValue).getComment());
            }
        } else {
            PropertiesStructure ps;
            PropertiesFileEntry entry = this.structure.getNthEntry(columnIndex - 1);
            String key = this.structure.keyAt(rowIndex);
            if (entry != null && key != null && (ps = entry.getHandler().getStructure()) != null) {
                Element.ItemElem item = ps.getItem(key);
                if (item != null) {
                    item.setValue(((StringPair)aValue).getValue());
                    item.setComment(((StringPair)aValue).getComment());
                    this.structure.sort(-1);
                } else if (((StringPair)aValue).getValue().length() > 0 || ((StringPair)aValue).getComment().length() > 0) {
                    ps.addItem(key, ((StringPair)aValue).getValue(), ((StringPair)aValue).getComment());
                    this.structure.sort(-1);
                }
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return !this.structure.isReadOnly();
        }
        PropertiesFileEntry entry = this.structure.getNthEntry(columnIndex - 1);
        if (entry != null) {
            return entry.getFile().canWrite();
        }
        return false;
    }

    public void fireTableColumnChanged(int index) {
        int columnModelIndex = index;
        Object[] list = this.listenerList.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof JTable)) continue;
            JTable jt = (JTable)list[i];
            try {
                TableColumn column = jt.getColumnModel().getColumn(index);
                columnModelIndex = column.getModelIndex();
                column.setHeaderValue(jt.getModel().getColumnName(columnModelIndex));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            jt.getTableHeader().repaint();
        }
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, columnModelIndex));
    }

    PropertiesFileEntry getFileEntry(int column) {
        return this.structure.getNthEntry(column - 1);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("------------------------------ TABLE MODEL DUMP -----------------------\n");
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                StringPair sp = (StringPair)this.getValueAt(row, column);
                result.append("[" + sp.getValue() + "]");
                if (column == 0) {
                    result.append(" : ");
                    continue;
                }
                if (column == this.getColumnCount() - 1) {
                    result.append("\n");
                    continue;
                }
                result.append(",");
            }
        }
        result.append("---------------------------- END TABLE MODEL DUMP ---------------------\n");
        return result.toString();
    }

    private void cancelEditingInTables(CancelSelector can) {
        Object[] list = this.listenerList.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            BundleEditPanel.BundleTable jt;
            if (!(list[i] instanceof BundleEditPanel.BundleTable) || !can.doCancelEditing((jt = (BundleEditPanel.BundleTable)list[i]).getEditingRow(), jt.getEditingColumn())) continue;
            jt.removeEditorSilent();
        }
    }

    private CancelSelector getDefaultCancelSelector() {
        return new CancelSelector(){

            @Override
            public boolean doCancelEditing(int row, int column) {
                return row >= 0 && row < PropertiesTableModel.this.getRowCount() && column >= 0 && column < PropertiesTableModel.this.getColumnCount();
            }
        };
    }

    private static interface CancelSelector {
        public boolean doCancelEditing(int var1, int var2);
    }

    private class TablePropertyBundleListener
    implements PropertyBundleListener {
        private TablePropertyBundleListener() {
        }

        @Override
        public void bundleChanged(final PropertyBundleEvent evt) {
            if (EventQueue.isDispatchThread()) {
                this.doBundleChanged(evt);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TablePropertyBundleListener.this.doBundleChanged(evt);
                    }
                });
            }
        }

        private void doBundleChanged(PropertyBundleEvent evt) {
            int changeType = evt.getChangeType();
            if (changeType == 1) {
                PropertiesTableModel.this.cancelEditingInTables(PropertiesTableModel.this.getDefaultCancelSelector());
                PropertiesTableModel.this.fireTableStructureChanged();
                Object[] list = PropertiesTableModel.this.listenerList.getListenerList();
                for (int i = 0; i < list.length; ++i) {
                    if (!(list[i] instanceof JTable)) continue;
                    ((JTable)list[i]).setModel(new PropertiesTableModel(PropertiesTableModel.this.structure));
                }
            } else if (changeType == 2) {
                PropertiesTableModel.this.cancelEditingInTables(PropertiesTableModel.this.getDefaultCancelSelector());
                Object[] list = PropertiesTableModel.this.listenerList.getListenerList();
                for (int i = 0; i < list.length; ++i) {
                    if (!(list[i] instanceof JTable)) continue;
                    JTable jt = (JTable)list[i];
                    for (int j = 0; j < jt.getColumnModel().getColumnCount(); ++j) {
                        TableColumn column = jt.getColumnModel().getColumn(j);
                        column.setHeaderValue(jt.getModel().getColumnName(j));
                    }
                }
                PropertiesTableModel.this.fireTableDataChanged();
            } else if (changeType == 3) {
                final int index = PropertiesTableModel.this.structure.getEntryIndexByFileName(evt.getEntryName());
                if (index == -1) {
                    PropertiesTableModel.this.fireTableStructureChanged();
                    return;
                }
                PropertiesTableModel.this.cancelEditingInTables(new CancelSelector(){

                    @Override
                    public boolean doCancelEditing(int row, int column) {
                        if (row < 0 || row >= PropertiesTableModel.this.getRowCount() || column < 0 || column >= PropertiesTableModel.this.getColumnCount()) {
                            return false;
                        }
                        return column == index + 1;
                    }
                });
                PropertiesTableModel.this.fireTableStructureChanged();
            } else if (changeType == 4) {
                final int index2 = PropertiesTableModel.this.structure.getEntryIndexByFileName(evt.getEntryName());
                final int keyIndex = PropertiesTableModel.this.structure.getKeyIndexByName(evt.getItemName());
                if (index2 == -1 || keyIndex == -1) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        new Exception("Changed file not found").printStackTrace();
                    }
                    return;
                }
                PropertiesTableModel.this.cancelEditingInTables(new CancelSelector(){

                    @Override
                    public boolean doCancelEditing(int row, int column) {
                        if (row < 0 || row >= PropertiesTableModel.this.getRowCount() || column < 0 || column >= PropertiesTableModel.this.getColumnCount()) {
                            return false;
                        }
                        return column == index2 + 1 && row == keyIndex;
                    }
                });
                PropertiesTableModel.this.fireTableCellUpdated(keyIndex, index2 + 1);
            }
        }
    }

    static class StringPair
    implements Serializable {
        private String comment;
        private String value;
        private boolean keyType;
        private boolean commentEditable;
        static final long serialVersionUID = -463968846283787181L;

        public StringPair() {
            this(null, "", false);
        }

        public StringPair(String v) {
            this(null, v, true);
        }

        public StringPair(String c, String v) {
            this(c, v, false);
        }

        public StringPair(String c, String v, boolean kt) {
            this.comment = c;
            this.value = v;
            this.keyType = kt;
            this.commentEditable = true;
        }

        public String getComment() {
            return this.comment;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StringPair)) {
                return false;
            }
            StringPair compared = (StringPair)obj;
            if (this.comment == null && compared.getComment() != null) {
                return false;
            }
            String str1 = this.comment;
            String str2 = compared.getComment();
            if (!str1.equals(str2)) {
                return false;
            }
            if (this.value == null && compared.getValue() != null) {
                return false;
            }
            str1 = this.value;
            str2 = compared.getValue();
            return str1.equals(str2);
        }

        public int hashCode() {
            int hash = 3;
            hash = 19 * hash + (this.comment != null ? this.comment.hashCode() : 0);
            hash = 19 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.value;
        }

        public boolean isKeyType() {
            return this.keyType;
        }

        public boolean isCommentEditable() {
            return this.commentEditable;
        }

        public void setCommentEditable(boolean newEditable) {
            this.commentEditable = newEditable;
        }
    }
}

