/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.breakpoints.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.TruffleLineBreakpoint;
import org.netbeans.modules.javascript2.debug.EditorLineHandler;
import org.netbeans.modules.javascript2.debug.EditorLineHandlerFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public class TruffleBreakpointReader
implements Properties.Reader {
    private static final Logger LOG = Logger.getLogger(TruffleBreakpointReader.class.getName());

    public String[] getSupportedClassNames() {
        return new String[]{TruffleLineBreakpoint.class.getName()};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object read(String className, Properties properties) {
        TruffleLineBreakpoint b = null;
        if (className.equals(TruffleLineBreakpoint.class.getName())) {
            String urlStr = properties.getString("url", null);
            int lineNumber = properties.getInt("lineNumber", 1);
            try {
                URL url = new URL(urlStr);
                FileObject fo = URLMapper.findFileObject((URL)url);
                if (fo == null) {
                    if (!this.isTransientURL(url)) return null;
                    EditorLineHandler line = EditorLineHandlerFactory.getHandler((URL)url, (int)lineNumber);
                    b = new TruffleLineBreakpoint(line);
                } else if (Lookup.getDefault().lookup(EditorLineHandlerFactory.class) != null) {
                    EditorLineHandler line = EditorLineHandlerFactory.getHandler((FileObject)fo, (int)lineNumber);
                    if (line == null) return null;
                    b = new TruffleLineBreakpoint(line);
                } else {
                    b = new TruffleLineBreakpoint(url, lineNumber);
                }
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.CONFIG, "urlStr = " + urlStr, ex);
                return null;
            }
        }
        if (b == null) {
            throw new IllegalStateException("Unknown breakpoint type: \"" + className + "\"");
        }
        b.setCondition(properties.getString("condition", null));
        b.setGroupName(properties.getString("groupName", ""));
        int hitCountFilter = properties.getInt("hitCountFilter", 0);
        Breakpoint.HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle = hitCountFilter > 0 ? Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[properties.getInt("hitCountFilter_style", 0)] : null;
        b.setHitCountFilter(hitCountFilter, hitCountFilteringStyle);
        if (properties.getBoolean("enabled", true)) {
            b.enable();
        } else {
            b.disable();
        }
        if (!b.canHaveDependentBreakpoints()) return b;
        return b;
    }

    private boolean isTransientURL(URL url) {
        return "truffle-scripts".equals(url.getProtocol());
    }

    public void write(Object object, Properties properties) {
        TruffleLineBreakpoint b = (TruffleLineBreakpoint)((Object)object);
        properties.setString("groupName", b.getGroupName());
        properties.setBoolean("enabled", b.isEnabled());
        properties.setInt("hitCountFilter", b.getHitCountFilter());
        Breakpoint.HIT_COUNT_FILTERING_STYLE style = b.getHitCountFilteringStyle();
        properties.setInt("hitCountFilter_style", style != null ? style.ordinal() : 0);
        if (b.canHaveDependentBreakpoints()) {
            // empty if block
        }
        properties.setString("condition", b.getCondition());
        URL url = b.getURL();
        int line = b.getLineNumber();
        properties.setString("url", url.toExternalForm());
        properties.setInt("lineNumber", line);
    }
}

