/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade.systemoptions;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Properties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

class PropertiesStorage {
    private static final String USERROOT_PREFIX = "/Preferences";
    private static final FileObject SFS_ROOT = FileUtil.getConfigRoot();
    private final String folderPath;
    private String filePath;

    static PropertiesStorage instance(String absolutePath) {
        return new PropertiesStorage(absolutePath);
    }

    FileObject preferencesRoot() throws IOException {
        return FileUtil.createFolder((FileObject)SFS_ROOT, (String)USERROOT_PREFIX);
    }

    private PropertiesStorage(String absolutePath) {
        StringBuilder sb = new StringBuilder();
        sb.append(USERROOT_PREFIX).append(absolutePath);
        this.folderPath = sb.toString();
    }

    public Properties load() throws IOException {
        Properties retval = new Properties();
        InputStream is = this.inputStream();
        if (is != null) {
            try {
                retval.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return retval;
    }

    public void save(Properties properties) throws IOException {
        if (!properties.isEmpty()) {
            try (OutputStream os = this.outputStream();){
                properties.store(os, new Date().toString());
            }
        } else {
            FileObject file = this.toPropertiesFile();
            if (file != null) {
                file.delete();
            }
            for (FileObject folder = this.toFolder(); folder != null && folder != this.preferencesRoot() && folder.getChildren().length == 0; folder = folder.getParent()) {
                folder.delete();
            }
        }
    }

    private InputStream inputStream() throws IOException {
        FileObject file = this.toPropertiesFile(false);
        return file == null ? null : file.getInputStream();
    }

    private OutputStream outputStream() throws IOException {
        FileObject fo = this.toPropertiesFile(true);
        final FileLock lock = fo.lock();
        OutputStream os = fo.getOutputStream(lock);
        return new FilterOutputStream(os){

            @Override
            public void close() throws IOException {
                super.close();
                lock.releaseLock();
            }
        };
    }

    private String folderPath() {
        return this.folderPath;
    }

    private String filePath() {
        if (this.filePath == null) {
            String[] all = this.folderPath().split("/");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < all.length - 1; ++i) {
                sb.append(all[i]).append("/");
            }
            if (all.length > 0) {
                sb.append(all[all.length - 1]).append(".properties");
            } else {
                sb.append("root.properties");
            }
            this.filePath = sb.toString();
        }
        return this.filePath;
    }

    protected FileObject toFolder() {
        return SFS_ROOT.getFileObject(this.folderPath);
    }

    protected FileObject toPropertiesFile() {
        return SFS_ROOT.getFileObject(this.filePath());
    }

    protected FileObject toFolder(boolean create) throws IOException {
        FileObject retval = this.toFolder();
        if (retval == null && create) {
            retval = FileUtil.createFolder((FileObject)SFS_ROOT, (String)this.folderPath);
        }
        assert (retval == null && !create || retval != null && retval.isFolder());
        return retval;
    }

    protected FileObject toPropertiesFile(boolean create) throws IOException {
        FileObject retval = this.toPropertiesFile();
        if (retval == null && create) {
            retval = FileUtil.createData((FileObject)SFS_ROOT, (String)this.filePath());
        }
        assert (retval == null && !create || retval != null && retval.isData());
        return retval;
    }
}

