/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.netbeans.modules.gradle.actions.DefaultActionMapping;
import org.netbeans.modules.gradle.api.execute.ActionMapping;

public final class ActionMappingPropertyReader {
    private static final String PARAM_ARGS = ".args";
    private static final String PARAM_PLUGINS = ".plugins";
    private static final String PARAM_PRIORITY = ".priority";
    private static final String PARAM_RELOAD_ARGS = ".reload.args";
    private static final String PARAM_RELOAD_RULE = ".reload.rule";
    private static final String PARAM_REPEATABLE = ".repeatable";
    final Properties props;

    ActionMappingPropertyReader(Properties props) {
        this.props = props;
    }

    public static Set<ActionMapping> loadMappings(Properties props) {
        ActionMappingPropertyReader reader = new ActionMappingPropertyReader(props);
        return Collections.unmodifiableSet(reader.buildMappings());
    }

    private Set<ActionMapping> buildMappings() {
        HashSet<ActionMapping> mappings = new HashSet<ActionMapping>();
        for (String actionName : this.getActionNames()) {
            mappings.add(this.createMapping(actionName));
        }
        return mappings;
    }

    private Set<String> getActionNames() {
        HashSet<String> ret = new HashSet<String>();
        for (String key : this.props.stringPropertyNames()) {
            if (!key.startsWith("action.")) continue;
            if (key.endsWith(PARAM_RELOAD_ARGS)) {
                ret.add(key.substring("action.".length(), key.length() - PARAM_RELOAD_ARGS.length()));
                continue;
            }
            if (!key.endsWith(PARAM_ARGS)) continue;
            ret.add(key.substring("action.".length(), key.length() - PARAM_ARGS.length()));
        }
        return ret;
    }

    private ActionMapping createMapping(String name) {
        DefaultActionMapping ret = new DefaultActionMapping(name);
        String prefix = "action." + name;
        ret.displayName = this.props.getProperty("action." + name);
        ret.args = this.props.getProperty(prefix + PARAM_ARGS);
        ret.reloadArgs = this.props.getProperty(prefix + PARAM_RELOAD_ARGS);
        String rule = this.props.getProperty(prefix + PARAM_RELOAD_RULE, ActionMapping.ReloadRule.DEFAULT.name());
        try {
            ret.reloadRule = ActionMapping.ReloadRule.valueOf(rule.trim());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String repeatable = this.props.getProperty(prefix + PARAM_REPEATABLE);
        if (repeatable != null) {
            ret.repeatableAction = Boolean.valueOf(repeatable);
        }
        if (this.props.containsKey(prefix + PARAM_PLUGINS)) {
            String[] plugins = this.props.getProperty(prefix + PARAM_PLUGINS).split(",\\s");
            ret.withPlugins = new LinkedHashSet<String>();
            ret.withPlugins.addAll(Arrays.asList(plugins));
        }
        if (this.props.containsKey(prefix + PARAM_PRIORITY)) {
            try {
                ret.priority = Integer.parseInt(this.props.getProperty(prefix + PARAM_PRIORITY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ret;
    }
}

