/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.responses;

import com.oracle.bmc.objectstorage.model.Bucket;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetBucketResponse
extends BmcResponse {
    private String opcClientRequestId;
    private String opcRequestId;
    private String eTag;
    private Bucket bucket;
    private boolean isNotModified;

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getETag() {
        return this.eTag;
    }

    public Bucket getBucket() {
        return this.bucket;
    }

    public boolean isNotModified() {
        return this.isNotModified;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcClientRequestId", "opcRequestId", "eTag", "bucket", "isNotModified"})
    private GetBucketResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcClientRequestId, String opcRequestId, String eTag, Bucket bucket, boolean isNotModified) {
        super(__httpStatusCode__, headers);
        this.opcClientRequestId = opcClientRequestId;
        this.opcRequestId = opcRequestId;
        this.eTag = eTag;
        this.bucket = bucket;
        this.isNotModified = isNotModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",eTag=").append(String.valueOf(this.eTag));
        sb.append(",bucket=").append(String.valueOf((Object)this.bucket));
        sb.append(",isNotModified=").append(this.isNotModified);
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBucketResponse)) {
            return false;
        }
        GetBucketResponse other = (GetBucketResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.eTag, other.eTag) && Objects.equals((Object)this.bucket, (Object)other.bucket) && this.isNotModified == other.isNotModified;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.eTag == null ? 43 : this.eTag.hashCode());
        result = result * 59 + (this.bucket == null ? 43 : this.bucket.hashCode());
        result = result * 59 + (this.isNotModified ? 79 : 97);
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetBucketResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcClientRequestId;
        private String opcRequestId;
        private String eTag;
        private Bucket bucket;
        private boolean isNotModified;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public Builder bucket(Bucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder isNotModified(boolean isNotModified) {
            this.isNotModified = isNotModified;
            return this;
        }

        public Builder copy(GetBucketResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.eTag(o.getETag());
            this.bucket(o.getBucket());
            this.isNotModified(o.isNotModified());
            return this;
        }

        public GetBucketResponse build() {
            return new GetBucketResponse(this.__httpStatusCode__, this.headers, this.opcClientRequestId, this.opcRequestId, this.eTag, this.bucket, this.isNotModified);
        }
    }
}

