/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.actions;

import java.awt.event.ActionEvent;
import org.netbeans.modules.payara.common.PayaraState;
import org.netbeans.modules.payara.common.actions.AbstractOutputAction;
import org.netbeans.modules.payara.common.utils.Util;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class DebugAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (Node node : activatedNodes) {
            PayaraModule commonSupport = (PayaraModule)node.getLookup().lookup(PayaraModule.class);
            if (commonSupport == null) continue;
            DebugAction.performActionImpl(commonSupport);
        }
    }

    private static void performActionImpl(PayaraModule commonSupport) {
        commonSupport.setEnvironmentProperty("jvmMode", PayaraModule.DEBUG_MODE, true);
        commonSupport.startServer(null, PayaraModule.ServerState.RUNNING);
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        if (activatedNodes != null && activatedNodes.length > 0) {
            Node node;
            PayaraModule commonSupport;
            Node[] nodeArray = activatedNodes;
            int n = nodeArray.length;
            for (int i = 0; i < n && (result = (commonSupport = (PayaraModule)(node = nodeArray[i]).getLookup().lookup(PayaraModule.class)) != null ? DebugAction.enableImpl(commonSupport) : false); ++i) {
            }
        }
        return result;
    }

    private static boolean enableImpl(PayaraModule commonSupport) {
        return !commonSupport.getInstance().isWSL() && PayaraState.canStart(commonSupport.getInstance()) && null != commonSupport.getInstanceProperties().get("domainsfolder") && Util.isDefaultOrServerTarget(commonSupport.getInstanceProperties());
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(DebugAction.class, (String)"CTL_DebugAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public static class OutputAction
    extends AbstractOutputAction {
        private static final String ICON = "org/netbeans/modules/payara/common/resources/debug.png";

        public OutputAction(PayaraModule commonSupport) {
            super(commonSupport, NbBundle.getMessage(DebugAction.class, (String)"LBL_DebugOutput"), NbBundle.getMessage(DebugAction.class, (String)"LBL_DebugOutputDesc"), ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebugAction.performActionImpl(this.commonSupport);
        }

        @Override
        public boolean isEnabled() {
            return DebugAction.enableImpl(this.commonSupport);
        }
    }
}

