/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.breakpoints.BreakpointsHandler;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointStatus;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.util.WeakListeners;

public final class SubmittedBreakpoint {
    private static final Logger LOG = Logger.getLogger(SubmittedBreakpoint.class.getName());
    private final JSLineBreakpoint breakpoint;
    private final List<Long> ids;
    private final List<SourceMapsTranslator.Location> bpLocs;
    private final V8Debugger dbg;
    private final PropertyChangeListener bpChangeListener;
    private final PropertyChangeListener addedChangeListener;

    SubmittedBreakpoint(JSLineBreakpoint breakpoint, List<Long> ids, List<SourceMapsTranslator.Location> bpLocs, List<V8Breakpoint.ActualLocation[]> actualLocations, V8Debugger dbg) {
        this.breakpoint = breakpoint;
        this.ids = ids;
        this.bpLocs = bpLocs;
        this.dbg = dbg;
        LOG.log(Level.FINE, "SubmittedBreakpoint({0}, {1})", new Object[]{breakpoint, ids});
        this.adjustLocation(ids, actualLocations);
        LOG.log(Level.FINE, "  adjusted BP => {0}", breakpoint);
        this.bpChangeListener = new BPChangeListener();
        this.addedChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.bpChangeListener, (Object)breakpoint);
        breakpoint.addPropertyChangeListener(this.addedChangeListener);
        JSBreakpointStatus.setValid((JSLineBreakpoint)breakpoint, null);
    }

    public JSLineBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    private void adjustLocation(List<Long> ids, List<V8Breakpoint.ActualLocation[]> actualLocationsList) {
        for (int i = 0; i < ids.size(); ++i) {
            Long id = ids.get(i);
            V8Breakpoint.ActualLocation[] actualLocations = actualLocationsList.get(i);
            if (actualLocations == null || actualLocations.length <= 0) continue;
            long line = actualLocations[0].getLine();
            long column = actualLocations[0].getColumn();
            this.updatePosition(id, line, column);
        }
    }

    void updatePosition(long id, long line, long column) {
        SourceMapsTranslator smt = this.dbg.getScriptsHandler().getSourceMapsTranslator();
        SourceMapsTranslator.Location bpLoc = this.bpLocs.get(this.ids.indexOf(id));
        if (smt != null && bpLoc != null) {
            SourceMapsTranslator.Location newLoc;
            SourceMapsTranslator.Location l;
            if (line == 0L) {
                column -= (long)this.dbg.getScriptsHandler().getScriptFirstLineColumnShift(bpLoc.getFile());
            }
            if ((l = smt.getSourceLocation(newLoc = new SourceMapsTranslator.Location(bpLoc.getFile(), (int)line, (int)column))) != newLoc) {
                line = l.getLine();
            }
        }
        if (this.ids.indexOf(id) == 0) {
            this.breakpoint.setLine((int)line + 1);
        }
    }

    void notifyDestroyed() {
        this.breakpoint.removePropertyChangeListener(this.addedChangeListener);
        JSBreakpointStatus.resetValidity((JSLineBreakpoint)this.breakpoint);
    }

    private final class BPChangeListener
    implements PropertyChangeListener {
        private BPChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "enabled": 
                case "condition": {
                    BreakpointsHandler.createChangeRequestArguments(SubmittedBreakpoint.this).stream().forEach(cbargs -> SubmittedBreakpoint.this.dbg.sendCommandRequest(V8Command.Changebreakpoint, (V8Arguments)cbargs));
                }
            }
        }
    }
}

