/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbSystemOptions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="storageManagement")
    private final StorageManagement storageManagement;

    @Deprecated
    @ConstructorProperties(value={"storageManagement"})
    public DbSystemOptions(StorageManagement storageManagement) {
        this.storageManagement = storageManagement;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public StorageManagement getStorageManagement() {
        return this.storageManagement;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbSystemOptions(");
        sb.append("super=").append(super.toString());
        sb.append("storageManagement=").append(String.valueOf((Object)this.storageManagement));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbSystemOptions)) {
            return false;
        }
        DbSystemOptions other = (DbSystemOptions)((Object)o);
        return Objects.equals((Object)this.storageManagement, (Object)other.storageManagement) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.storageManagement == null ? 43 : this.storageManagement.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum StorageManagement implements BmcEnum
    {
        Asm("ASM"),
        Lvm("LVM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StorageManagement> map;

        private StorageManagement(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StorageManagement create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StorageManagement', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StorageManagement.class);
            map = new HashMap<String, StorageManagement>();
            for (StorageManagement v : StorageManagement.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="storageManagement")
        private StorageManagement storageManagement;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder storageManagement(StorageManagement storageManagement) {
            this.storageManagement = storageManagement;
            this.__explicitlySet__.add("storageManagement");
            return this;
        }

        public DbSystemOptions build() {
            DbSystemOptions model = new DbSystemOptions(this.storageManagement);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbSystemOptions model) {
            if (model.wasPropertyExplicitlySet("storageManagement")) {
                this.storageManagement(model.getStorageManagement());
            }
            return this;
        }
    }
}

