/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jsui.vars.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.List;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.js.vars.JSThis;
import org.netbeans.modules.debugger.jpda.js.vars.JSVariable;
import org.netbeans.modules.debugger.jpda.js.vars.ScopeVariable;
import org.netbeans.modules.debugger.jpda.jsui.vars.models.JSWatchVar;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.datatransfer.PasteType;

public class VariablesJSNodeModel
implements ExtendedNodeModelFilter {
    private static final String GLOBAL = "org/netbeans/modules/javascript2/debug/ui/resources/global_variable_16.png";

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canRename(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCopy(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.canCut(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCopy(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws IOException, UnknownTypeException {
        return original.clipboardCut(node);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        return original.getPasteTypes(node, t);
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        original.setName(node, name);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSThis) {
            return original.getIconBaseWithExtension((Object)new EmptyThis());
        }
        if (node instanceof JSVariable) {
            return original.getIconBaseWithExtension((Object)new EmptyVar());
        }
        if (node instanceof JSWatchVar) {
            return original.getIconBaseWithExtension((Object)((JSWatchVar)node).getWatch());
        }
        if (node instanceof ScopeVariable) {
            return GLOBAL;
        }
        return original.getIconBaseWithExtension(node);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSVariable) {
            return ((JSVariable)node).getKey();
        }
        if (node instanceof ScopeVariable) {
            return ((ScopeVariable)node).getName();
        }
        if (node instanceof JSWatchVar) {
            JSWatchVar jswv = (JSWatchVar)node;
            node = jswv.getWatch();
        }
        return original.getDisplayName(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JSVariable) {
            JSVariable var = (JSVariable)node;
            return var.getKey() + " = " + var.getValue();
        }
        if (node instanceof ScopeVariable) {
            return ((ScopeVariable)node).getName();
        }
        if (node instanceof JSWatchVar) {
            JSWatchVar jswv = (JSWatchVar)node;
            JSVariable jsVar = jswv.getJSVar();
            if (jsVar != null) {
                return jswv.getWatch().getExpression() + " = " + jsVar.getValue();
            }
            node = jswv.getWatch();
        }
        return original.getShortDescription(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static final class EmptyThis
    implements This {
        private EmptyThis() {
        }

        public String getToStringValue() throws InvalidExpressionException {
            return "empty";
        }

        public Variable invokeMethod(String methodName, String signature, Variable[] arguments) throws NoSuchMethodException, InvalidExpressionException {
            throw new UnsupportedOperationException("Not supported.");
        }

        public int getFieldsCount() {
            return 0;
        }

        public Field getField(String name) {
            return null;
        }

        public Field[] getFields(int from, int to) {
            return null;
        }

        public Field[] getAllStaticFields(int from, int to) {
            return null;
        }

        public Field[] getInheritedFields(int from, int to) {
            return null;
        }

        public List<ObjectVariable> getReferringObjects(long maxReferrers) throws UnsupportedOperationException {
            return null;
        }

        public Super getSuper() {
            return null;
        }

        public JPDAClassType getClassType() {
            return null;
        }

        public long getUniqueID() {
            return 0L;
        }

        public String getType() {
            return "empty";
        }

        public String getValue() {
            return "";
        }

        public Object createMirrorObject() {
            return null;
        }
    }

    private static final class EmptyVar
    implements Variable {
        private EmptyVar() {
        }

        public String getType() {
            return "empty";
        }

        public String getValue() {
            return "";
        }

        public Object createMirrorObject() {
            return null;
        }
    }
}

