/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Element;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public class QuickOpen
extends CodeActionsProvider {
    public static final String QUICK_OPEN = "nbls.quick.open";
    public static final String DEFAULT_PKG = "<default package>";
    private final Gson gson = new Gson();

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(QUICK_OPEN);
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        LspServerState server = (LspServerState)Lookup.getDefault().lookup(LspServerState.class);
        if (server != null) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)server.openedProjects().thenCompose(prjs -> {
                ArrayList<QuickPickItem> items = new ArrayList<QuickPickItem>();
                for (Project prj : prjs) {
                    for (SourceGroup sg : ProjectUtils.getSources((Project)prj).getSourceGroups("java")) {
                        FileObject root = sg.getRootFolder();
                        for (ElementHandle type : ClasspathInfo.create((FileObject)root).getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE))) {
                            String qualifiedName = type.getQualifiedName();
                            int idx = qualifiedName.lastIndexOf(46);
                            String name = idx < 0 ? qualifiedName : qualifiedName.substring(idx + 1);
                            String pkgName = idx < 0 ? DEFAULT_PKG : qualifiedName.substring(0, idx);
                            items.add(new QuickPickItem(name, pkgName + " : " + root.toURI().toString(), null, false, new CodeActionsProvider.ElementData((ElementHandle<? extends Element>)type)));
                        }
                    }
                }
                if (items.isEmpty()) {
                    client.showMessage(new MessageParams(MessageType.Error, Bundle.DN_NoTypeFound()));
                    return CompletableFuture.completedFuture(null);
                }
                return client.showQuickPick(new ShowQuickPickParams(Bundle.DN_SelectType(), items));
            })).thenCompose(selected -> {
                if (selected != null && !selected.isEmpty()) {
                    QuickPickItem item = (QuickPickItem)selected.get(0);
                    String description = item.getDescription();
                    int idx = description.indexOf(" : ");
                    String rootUri = description.substring(idx + 3);
                    FileObject root = null;
                    try {
                        root = URLMapper.findFileObject((URL)URI.create(rootUri).toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (root != null) {
                        CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                        ElementHandle typeHandle = data.toHandle();
                        return ElementOpen.getLocation((ClasspathInfo)ClasspathInfo.create((FileObject)root), (ElementHandle)typeHandle, (String)(typeHandle.getQualifiedName().replace('.', '/') + ".class"));
                    }
                }
                return CompletableFuture.completedFuture(null);
            })).thenCompose(loc -> {
                if (loc != null) {
                    ShowDocumentParams sdp = new ShowDocumentParams(Utils.toUri(loc.getFileObject()));
                    Position position = Utils.createPosition(loc.getFileObject(), loc.getStartOffset());
                    sdp.setSelection(new Range(position, position));
                    return client.showDocument(sdp);
                }
                return CompletableFuture.completedFuture(null);
            })).thenApply(result -> result != null ? result.isSuccess() : false);
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }
}

