/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JFXSigningPanel
extends JPanel
implements DocumentListener {
    private final JFXProjectProperties jfxProps;
    private DialogDescriptor desc;
    private ButtonGroup buttonGroupSigning;
    private JButton buttonPath;
    private Box.Filler filler1;
    private JLabel labelKeyAlias;
    private JLabel labelKeyPassword;
    private JLabel labelPassword;
    private JLabel labelPath;
    private JPasswordField passwordField;
    private JPasswordField passwordFieldKey;
    private JRadioButton radioButtonSelfSign;
    private JRadioButton radioButtonSpecKey;
    private JTextField textFieldKeyAlias;
    private JTextField textFieldPath;
    private JLabel warningSigning;

    public JFXSigningPanel(JFXProjectProperties props) {
        this.jfxProps = props;
        this.initComponents();
        if (JFXProjectProperties.SigningType.KEY == this.jfxProps.getSigningType()) {
            this.radioButtonSpecKey.setSelected(true);
        } else {
            this.radioButtonSelfSign.setSelected(true);
        }
        this.textFieldPath.setText(this.jfxProps.getSigningKeyStore());
        this.textFieldKeyAlias.setText(this.jfxProps.getSigningKeyAlias());
        if (this.jfxProps.getSigningKeyStorePassword() != null) {
            this.passwordField.setText(new String(this.jfxProps.getSigningKeyStorePassword()));
        }
        if (this.jfxProps.getSigningKeyPassword() != null) {
            this.passwordFieldKey.setText(new String(this.jfxProps.getSigningKeyPassword()));
        }
        this.refreshComponents();
    }

    void setDialogDescriptor(DialogDescriptor desc) {
        this.desc = desc;
        this.updateDialogButtonsAndMessage();
    }

    void registerListeners() {
        this.textFieldPath.getDocument().addDocumentListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
        this.textFieldKeyAlias.getDocument().addDocumentListener(this);
        this.passwordFieldKey.getDocument().addDocumentListener(this);
    }

    void unregisterListeners() {
        this.textFieldPath.getDocument().removeDocumentListener(this);
        this.passwordField.getDocument().removeDocumentListener(this);
        this.textFieldKeyAlias.getDocument().removeDocumentListener(this);
        this.passwordFieldKey.getDocument().removeDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateDialogButtonsAndMessage();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateDialogButtonsAndMessage();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateDialogButtonsAndMessage();
    }

    private void refreshComponents() {
        boolean keyAlias = this.radioButtonSpecKey.isSelected();
        this.textFieldPath.setEnabled(keyAlias);
        this.buttonPath.setEnabled(keyAlias);
        this.passwordField.setEnabled(keyAlias);
        this.textFieldKeyAlias.setEnabled(keyAlias);
        this.passwordFieldKey.setEnabled(keyAlias);
        this.labelPath.setEnabled(keyAlias);
        this.labelPassword.setEnabled(keyAlias);
        this.labelKeyAlias.setEnabled(keyAlias);
        this.labelKeyPassword.setEnabled(keyAlias);
    }

    void store() {
        if (this.radioButtonSelfSign.isSelected()) {
            this.jfxProps.setSigningType(JFXProjectProperties.SigningType.SELF);
        } else {
            this.jfxProps.setSigningType(JFXProjectProperties.SigningType.KEY);
        }
        this.jfxProps.setSigningKeyStore(this.textFieldPath.getText().trim());
        this.jfxProps.setSigningKeyStorePassword(this.passwordField.getPassword());
        this.jfxProps.setSigningKeyAlias(this.textFieldKeyAlias.getText().trim());
        this.jfxProps.setSigningKeyPassword(this.passwordFieldKey.getPassword());
    }

    private void initComponents() {
        this.buttonGroupSigning = new ButtonGroup();
        this.radioButtonSelfSign = new JRadioButton();
        this.radioButtonSpecKey = new JRadioButton();
        this.labelPath = new JLabel();
        this.textFieldPath = new JTextField();
        this.buttonPath = new JButton();
        this.labelPassword = new JLabel();
        this.passwordField = new JPasswordField();
        this.labelKeyAlias = new JLabel();
        this.textFieldKeyAlias = new JTextField();
        this.labelKeyPassword = new JLabel();
        this.passwordFieldKey = new JPasswordField();
        this.warningSigning = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.setPreferredSize(new Dimension(570, 240));
        this.setLayout(new GridBagLayout());
        this.buttonGroupSigning.add(this.radioButtonSelfSign);
        this.radioButtonSelfSign.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.radioButtonSelfSign, (String)NbBundle.getMessage(JFXSigningPanel.class, (String)"LBL_JFXSigningPanel.radioButtonSelfSign.text"));
        this.radioButtonSelfSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXSigningPanel.this.radioButtonSelfSignActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.radioButtonSelfSign, gridBagConstraints);
        this.radioButtonSelfSign.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXSigningPanel.class, (String)"AN_JFXSigningPanel.radioButtonSelfSign.text"));
        this.radioButtonSelfSign.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXSigningPanel.class, (String)"AD_JFXSigningPanel.radioButtonSelfSign.text"));
        this.buttonGroupSigning.add(this.radioButtonSpecKey);
        Mnemonics.setLocalizedText((AbstractButton)this.radioButtonSpecKey, (String)NbBundle.getMessage(JFXSigningPanel.class, (String)"LBL_JFXSigningPanel.radioButtonSpecKey.text"));
        this.radioButtonSpecKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXSigningPanel.this.radioButtonSpecKeyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(5, 10, 10, 0);
        this.add((Component)this.radioButtonSpecKey, gridBagConstraints);
        this.radioButtonSpecKey.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXSigningPanel.class, (String)"AN_JFXSigningPanel.radioButtonSpecKey.text"));
        this.radioButtonSpecKey.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXSigningPanel.class, (String)"AD_JFXSigningPanel.radioButtonSpecKey.text"));
        this.labelPath.setLabelFor(this.textFieldPath);
        Mnemonics.setLocalizedText((JLabel)this.labelPath, (String)NbBundle.getMessage(JFXSigningPanel.class, (String)"LBL_JFXSigningPanel.labelPath.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 20, 7, 0);
        this.add((Component)this.labelPath, gridBagConstraints);
        this.labelPath.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXSigningPanel.class, (String)"AN_JFXSigningPanel.labelPath.text"));
        this.labelPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXSigningPanel.class, (String)"AD_JFXSigningPanel.labelPath.text"));
        this.textFieldPath.setPreferredSize(new Dimension(350, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 7, 0);
        this.add((Component)this.textFieldPath, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonPath, (String)NbBundle.getMessage(JFXSigningPanel.class, (String)"LBL_JFXSigningPanel.buttonPath.text"));
        this.buttonPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXSigningPanel.this.buttonPathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(0, 5, 2, 10);
        this.add((Component)this.buttonPath, gridBagConstraints);
        this.buttonPath.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXSigningPanel.class, (String)"AN_JFXSigningPanel.buttonPath.text"));
        this.buttonPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXSigningPanel.class, (String)"AD_JFXSigningPanel.buttonPath.text"));
        this.labelPassword.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.labelPassword, (String)NbBundle.getMessage(JFXSigningPanel.class, (String)"LBL_JFXSigningPanel.labelPassword.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 20, 7, 0);
        this.add((Component)this.labelPassword, gridBagConstraints);
        this.labelPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXSigningPanel.class, (String)"AN_JFXSigningPanel.labelPassword.text"));
        this.labelPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXSigningPanel.class, (String)"AD_JFXSigningPanel.labelPassword.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 7, 0);
        this.add((Component)this.passwordField, gridBagConstraints);
        this.labelKeyAlias.setLabelFor(this.textFieldKeyAlias);
        Mnemonics.setLocalizedText((JLabel)this.labelKeyAlias, (String)NbBundle.getMessage(JFXSigningPanel.class, (String)"LBL_JFXSigningPanel.labelKeyAlias.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 20, 7, 0);
        this.add((Component)this.labelKeyAlias, gridBagConstraints);
        this.labelKeyAlias.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXSigningPanel.class, (String)"AN_JFXSigningPanel.labelKeyAlias.text"));
        this.labelKeyAlias.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXSigningPanel.class, (String)"AD_JFXSigningPanel.labelKeyAlias.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 7, 0);
        this.add((Component)this.textFieldKeyAlias, gridBagConstraints);
        this.labelKeyPassword.setLabelFor(this.passwordFieldKey);
        Mnemonics.setLocalizedText((JLabel)this.labelKeyPassword, (String)NbBundle.getMessage(JFXSigningPanel.class, (String)"LBL_JFXSigningPanel.labelKeyPassword.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 20, 3, 0);
        this.add((Component)this.labelKeyPassword, gridBagConstraints);
        this.labelKeyPassword.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXSigningPanel.class, (String)"AN_JFXSigningPanel.labelKeyPassword.text"));
        this.labelKeyPassword.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXSigningPanel.class, (String)"AD_JFXSigningPanel.labelKeyPassword.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 3, 0);
        this.add((Component)this.passwordFieldKey, gridBagConstraints);
        this.warningSigning.setText(NbBundle.getMessage(JFXSigningPanel.class, (String)"JFXSigningPanel.warningSigning.text"));
        this.warningSigning.setVerticalAlignment(3);
        this.warningSigning.setPreferredSize(new Dimension(400, 40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(2, 10, 0, 10);
        this.add((Component)this.warningSigning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler1, gridBagConstraints);
    }

    private void radioButtonSpecKeyActionPerformed(ActionEvent evt) {
        this.refreshComponents();
        this.updateDialogButtonsAndMessage();
    }

    private void radioButtonSelfSignActionPerformed(ActionEvent evt) {
        this.refreshComponents();
        this.updateDialogButtonsAndMessage();
    }

    private void buttonPathActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(JFXSigningPanel.class, (String)"TITLE_KeystoreBrowser"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.textFieldPath.setText(file.getAbsolutePath());
        }
    }

    private void updateDialogButtonsAndMessage() {
        if (!this.radioButtonSpecKey.isSelected()) {
            this.warningSigning.setText(NbBundle.getMessage(JFXSigningPanel.class, (String)"JFXSigningPanel.warningSigning.message"));
            this.warningSigning.setVisible(true);
            this.desc.setValid(true);
        } else if (this.textFieldPath.getDocument().getLength() > 0 && this.passwordField.getDocument().getLength() > 5 && this.textFieldKeyAlias.getDocument().getLength() > 0 && this.passwordFieldKey.getDocument().getLength() > 5) {
            this.desc.setValid(true);
            this.warningSigning.setText(null);
            this.warningSigning.setVisible(false);
        } else {
            this.desc.setValid(false);
            this.warningSigning.setText(NbBundle.getMessage(JFXSigningPanel.class, (String)"JFXSigningPanel.WarnMissingInfo"));
            this.warningSigning.setVisible(true);
        }
    }
}

